/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.keyvalue.TarContainerPacker;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.replication.ContainerReplicationSource;
import org.apache.hadoop.ozone.container.replication.CopyContainerCompression;

public class OnDemandContainerReplicationSource
implements ContainerReplicationSource {
    private final ContainerController controller;

    public OnDemandContainerReplicationSource(ContainerController controller) {
        this.controller = controller;
    }

    @Override
    public void prepare(long containerId) {
    }

    @Override
    public void copyData(long containerId, OutputStream destination, CopyContainerCompression compression) throws IOException {
        Container container = this.controller.getContainer(containerId);
        if (container == null) {
            throw new StorageContainerException("Container " + containerId + " is not found.", ContainerProtos.Result.CONTAINER_NOT_FOUND);
        }
        this.controller.exportContainer(container.getContainerType(), containerId, destination, new TarContainerPacker(compression));
    }
}

