/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.upgrade;

import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.hdds.upgrade.HDDSUpgradeAction;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeConfiguration;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeStateMachine;
import org.apache.hadoop.ozone.container.common.utils.HddsVolumeUtil;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.ozone.upgrade.UpgradeActionHdds;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UpgradeActionHdds(feature=HDDSLayoutFeature.DATANODE_SCHEMA_V3, component=UpgradeActionHdds.Component.DATANODE, type=LayoutFeature.UpgradeActionType.ON_FINALIZE)
public class DatanodeSchemaV3FinalizeAction
implements HDDSUpgradeAction<DatanodeStateMachine> {
    public static final Logger LOG = LoggerFactory.getLogger(DatanodeSchemaV3FinalizeAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DatanodeStateMachine dsm) throws Exception {
        LOG.info("Upgrading Datanode volume layout for Schema V3 support.");
        MutableVolumeSet dataVolumeSet = dsm.getContainer().getVolumeSet();
        MutableVolumeSet dbVolumeSet = dsm.getContainer().getDbVolumeSet();
        Preconditions.assertNotNull((Object)dataVolumeSet, (String)"Data Volume should not be null");
        dataVolumeSet.writeLock();
        try {
            for (StorageVolume hddsVolume : dataVolumeSet.getVolumesList()) {
                HddsVolume dataVolume = (HddsVolume)hddsVolume;
                if (dataVolume.getDbParentDir() != null) continue;
                dataVolume.createDbStore(dbVolumeSet);
            }
        }
        finally {
            dataVolumeSet.writeUnlock();
        }
        DatanodeConfiguration dcf = (DatanodeConfiguration)((Object)dsm.getConf().getObject(DatanodeConfiguration.class));
        if (!dcf.getContainerSchemaV3Enabled()) {
            LOG.info("Schema V3 is disabled. Won't load RocksDB in upgrade.");
            return;
        }
        HddsVolumeUtil.loadAllHddsVolumeDbStore(dataVolumeSet, dbVolumeSet, false, LOG);
    }
}

