/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.symmetric;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.security.symmetric.ManagedSecretKey;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyState;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecretKeyStateImpl
implements SecretKeyState {
    private static final Logger LOG = LoggerFactory.getLogger(SecretKeyStateImpl.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private List<ManagedSecretKey> sortedKeys;
    private ManagedSecretKey currentKey;
    private Map<UUID, ManagedSecretKey> keyById;
    private final SecretKeyStore keyStore;

    public SecretKeyStateImpl(SecretKeyStore keyStore) {
        this.keyStore = Objects.requireNonNull(keyStore);
    }

    @Override
    public ManagedSecretKey getCurrentKey() {
        this.lock.readLock().lock();
        try {
            ManagedSecretKey managedSecretKey = this.currentKey;
            return managedSecretKey;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ManagedSecretKey getKey(UUID id) {
        this.lock.readLock().lock();
        try {
            if (this.keyById == null) {
                ManagedSecretKey managedSecretKey = null;
                return managedSecretKey;
            }
            ManagedSecretKey managedSecretKey = this.keyById.get(id);
            return managedSecretKey;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public List<ManagedSecretKey> getSortedKeys() {
        this.lock.readLock().lock();
        try {
            List<ManagedSecretKey> list = this.sortedKeys;
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void updateKeys(List<ManagedSecretKey> newKeys) {
        this.updateKeysInternal(newKeys);
    }

    private void updateKeysInternal(List<ManagedSecretKey> newKeys) {
        LOG.info("Updating keys with {}", newKeys);
        this.lock.writeLock().lock();
        try {
            this.sortedKeys = Collections.unmodifiableList(newKeys.stream().sorted(Comparator.comparing(ManagedSecretKey::getCreationTime).reversed()).collect(Collectors.toList()));
            this.currentKey = this.sortedKeys.get(0);
            this.keyById = newKeys.stream().collect(Collectors.toMap(ManagedSecretKey::getId, Function.identity()));
            LOG.info("Current key updated {}", (Object)this.currentKey);
            this.keyStore.save(this.sortedKeys);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void reinitialize(List<ManagedSecretKey> secretKeys) {
        this.updateKeysInternal(secretKeys);
    }
}

