/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.token;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyVerifierClient;
import org.apache.hadoop.hdds.security.token.BlockTokenException;
import org.apache.hadoop.hdds.security.token.BlockTokenVerifier;
import org.apache.hadoop.hdds.security.token.CompositeTokenVerifier;
import org.apache.hadoop.hdds.security.token.ContainerTokenVerifier;
import org.apache.hadoop.hdds.security.token.NoopTokenVerifier;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface TokenVerifier {
    public void verify(Token<?> var1, ContainerProtos.ContainerCommandRequestProtoOrBuilder var2) throws SCMSecurityException;

    default public void verify(ContainerProtos.ContainerCommandRequestProtoOrBuilder cmd, String encodedToken) throws SCMSecurityException {
        if (Strings.isNullOrEmpty((String)encodedToken)) {
            throw new BlockTokenException("Failed to find any token (empty or null.)");
        }
        Token token = new Token();
        try {
            token.decodeFromUrlString(encodedToken);
        }
        catch (IOException ex) {
            throw new BlockTokenException("Failed to decode token : " + encodedToken);
        }
        this.verify(token, cmd);
    }

    public static TokenVerifier create(SecurityConfig conf, SecretKeyVerifierClient secretKeyClient) throws IOException {
        if (!conf.isBlockTokenEnabled() && !conf.isContainerTokenEnabled()) {
            return new NoopTokenVerifier();
        }
        LinkedList<TokenVerifier> list = new LinkedList<TokenVerifier>();
        list.add(new BlockTokenVerifier(conf, secretKeyClient));
        list.add(new ContainerTokenVerifier(conf, secretKeyClient));
        return new CompositeTokenVerifier(list);
    }
}

