/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RDBCheckpointUtils {
    static final Logger LOG = LoggerFactory.getLogger(RDBCheckpointUtils.class);
    private static final Duration POLL_INTERVAL_DURATION = Duration.ofMillis(100L);
    private static final Duration POLL_MAX_DURATION = Duration.ofSeconds(20L);

    private RDBCheckpointUtils() {
    }

    public static boolean waitForCheckpointDirectoryExist(File file, Duration maxWaitTimeout) {
        boolean success = RatisHelper.attemptUntilTrue(file::exists, (Duration)POLL_INTERVAL_DURATION, (Duration)maxWaitTimeout);
        if (!success) {
            LOG.info("Checkpoint directory: {} didn't get created in {} secs.", (Object)file.getAbsolutePath(), (Object)maxWaitTimeout.getSeconds());
        }
        return success;
    }

    public static boolean waitForCheckpointDirectoryExist(File file) throws IOException {
        return RDBCheckpointUtils.waitForCheckpointDirectoryExist(file, POLL_MAX_DURATION);
    }
}

