/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.ozone.common.InconsistentStorageStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class StorageInfo {
    public static final Logger LOG = LoggerFactory.getLogger(StorageInfo.class);
    private Properties properties = new Properties();
    private static final String NODE_TYPE = "nodeType";
    private static final String CLUSTER_ID = "clusterID";
    private static final String CREATION_TIME = "cTime";
    private static final String LAYOUT_VERSION = "layoutVersion";
    private static final String FIRST_UPGRADE_ACTION_LAYOUT_VERSION = "firstUpgradeActionLayoutVersion";
    private static final int INVALID_LAYOUT_VERSION = -1;

    public StorageInfo(HddsProtos.NodeType type, String cid, long cT, int layout) throws IOException {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)cid);
        this.properties.setProperty(NODE_TYPE, type.name());
        this.properties.setProperty(CLUSTER_ID, cid);
        this.properties.setProperty(CREATION_TIME, String.valueOf(cT));
        this.properties.setProperty(LAYOUT_VERSION, Integer.toString(layout));
    }

    public StorageInfo(HddsProtos.NodeType type, File propertiesFile) throws IOException {
        this.properties = this.readFrom(propertiesFile);
        this.verifyNodeType(type);
        this.verifyClusterId();
        this.verifyCreationTime();
        this.verifyLayoutVersion();
    }

    public HddsProtos.NodeType getNodeType() {
        return HddsProtos.NodeType.valueOf((String)this.properties.getProperty(NODE_TYPE));
    }

    public String getClusterID() {
        return this.properties.getProperty(CLUSTER_ID);
    }

    public Long getCreationTime() {
        String creationTime = this.properties.getProperty(CREATION_TIME);
        if (creationTime != null) {
            return Long.parseLong(creationTime);
        }
        return null;
    }

    public int getLayoutVersion() {
        String layout = this.properties.getProperty(LAYOUT_VERSION);
        if (layout != null) {
            return Integer.parseInt(layout);
        }
        return 0;
    }

    private void verifyLayoutVersion() {
        String layout = this.getProperty(LAYOUT_VERSION);
        if (layout == null) {
            LOG.warn("Found VERSION file without any layout version. Defaulting to 0.");
            this.setProperty(LAYOUT_VERSION, "0");
        }
    }

    public int getFirstUpgradeActionLayoutVersion() {
        String upgradingTo = this.properties.getProperty(FIRST_UPGRADE_ACTION_LAYOUT_VERSION);
        if (upgradingTo != null) {
            return Integer.parseInt(upgradingTo);
        }
        return -1;
    }

    public void setFirstUpgradeActionLayoutVersion(int layoutVersion) {
        this.properties.setProperty(FIRST_UPGRADE_ACTION_LAYOUT_VERSION, Integer.toString(layoutVersion));
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public void unsetProperty(String key) {
        this.properties.remove(key);
    }

    public void setClusterId(String clusterId) {
        this.properties.setProperty(CLUSTER_ID, clusterId);
    }

    public void setLayoutVersion(int version) {
        this.properties.setProperty(LAYOUT_VERSION, Integer.toString(version));
    }

    private void verifyNodeType(HddsProtos.NodeType type) throws InconsistentStorageStateException {
        HddsProtos.NodeType nodeType = this.getNodeType();
        Preconditions.checkNotNull((Object)nodeType);
        if (type != nodeType) {
            throw new InconsistentStorageStateException("Expected NodeType: " + type + ", but found: " + nodeType);
        }
    }

    private void verifyClusterId() throws InconsistentStorageStateException {
        String clusterId = this.getClusterID();
        Preconditions.checkNotNull((Object)clusterId);
        if (clusterId.isEmpty()) {
            throw new InconsistentStorageStateException("Cluster ID not found");
        }
    }

    private void verifyCreationTime() {
        Long creationTime = this.getCreationTime();
        Preconditions.checkNotNull((Object)creationTime);
    }

    public void writeTo(File to) throws IOException {
        IOUtils.writePropertiesToFile((File)to, (Properties)this.properties);
    }

    private Properties readFrom(File from) throws IOException {
        return IOUtils.readPropertiesFromFile((File)from);
    }

    public static String newClusterID() {
        return "CID-" + UUID.randomUUID().toString();
    }
}

