/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.EnumSet;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Context;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectJoinStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.ArrayTable;
import org.jooq.impl.CommonTableExpressionImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.DerivedTable;
import org.jooq.impl.Keywords;
import org.jooq.impl.SelectFieldList;
import org.jooq.impl.TableImpl;
import org.jooq.impl.Tools;

final class Alias<Q extends QueryPart>
extends AbstractQueryPart {
    private static final long serialVersionUID = -2456848365524191614L;
    private static final Clause[] CLAUSES_TABLE_REFERENCE = new Clause[]{Clause.TABLE, Clause.TABLE_REFERENCE};
    private static final Clause[] CLAUSES_TABLE_ALIAS = new Clause[]{Clause.TABLE, Clause.TABLE_ALIAS};
    private static final Clause[] CLAUSES_FIELD_REFERENCE = new Clause[]{Clause.FIELD, Clause.FIELD_REFERENCE};
    private static final Clause[] CLAUSES_FIELD_ALIAS = new Clause[]{Clause.FIELD, Clause.FIELD_ALIAS};
    private static final EnumSet<SQLDialect> SUPPORT_AS_REQUIRED = EnumSet.of(SQLDialect.DERBY, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES);
    private static final EnumSet<SQLDialect> SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL1 = EnumSet.of(SQLDialect.CUBRID, SQLDialect.FIREBIRD);
    private static final EnumSet<SQLDialect> SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL2 = EnumSet.of(SQLDialect.H2, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    final Q wrapped;
    final Q wrapping;
    final Name alias;
    final Name[] fieldAliases;
    final boolean wrapInParentheses;

    Alias(Q wrapped, Q wrapping, Name alias) {
        this(wrapped, wrapping, alias, null, false);
    }

    Alias(Q wrapped, Q wrapping, Name alias, boolean wrapInParentheses) {
        this(wrapped, wrapping, alias, null, wrapInParentheses);
    }

    Alias(Q wrapped, Q wrapping, Name alias, Name[] fieldAliases) {
        this(wrapped, wrapping, alias, fieldAliases, false);
    }

    Alias(Q wrapped, Q wrapping, Name alias, Name[] fieldAliases, boolean wrapInParentheses) {
        this.wrapped = wrapped;
        this.wrapping = wrapping;
        this.alias = alias;
        this.fieldAliases = fieldAliases;
        this.wrapInParentheses = wrapInParentheses;
    }

    final Q wrapped() {
        return this.wrapped;
    }

    @Override
    public final void accept(Context<?> context) {
        boolean qualify = context.qualify();
        if (context.declareAliases() && (context.declareFields() || context.declareTables())) {
            context.declareAliases(false);
            if (this.wrapped instanceof TableImpl) {
                context.scopeMarkStart((QueryPart)this.wrapping);
            }
            SQLDialect family = context.family();
            boolean emulatedDerivedColumnList = false;
            if (this.fieldAliases != null && SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL1.contains((Object)family) && (this.wrapped instanceof TableImpl || this.wrapped instanceof CommonTableExpressionImpl)) {
                SelectJoinStep select = DSL.select(DSL.asterisk()).from((TableLike<?>)((Table)this.wrapped).as(this.alias));
                context.sql('(').formatIndentStart().formatNewLine().visit(select).formatIndentEnd().formatNewLine().sql(')');
            } else if (this.fieldAliases != null && SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL2.contains((Object)family)) {
                emulatedDerivedColumnList = true;
                SelectFieldList fields = new SelectFieldList();
                for (Name fieldAlias : this.fieldAliases) {
                    switch (family) {
                        default: 
                    }
                    fields.add(DSL.field("null").as(fieldAlias));
                }
                Select select = DSL.select(fields).where((Condition)DSL.falseCondition()).unionAll(this.wrapped instanceof Select ? (Select)this.wrapped : (this.wrapped instanceof DerivedTable ? ((DerivedTable)this.wrapped).query() : DSL.select(DSL.asterisk()).from((TableLike<?>)((Table)this.wrapped).as(this.alias))));
                context.sql('(').formatIndentStart().formatNewLine().visit(select).formatIndentEnd().formatNewLine().sql(')');
            } else {
                this.toSQLWrapped(context);
            }
            Alias.toSQLAs(context);
            context.sql(' ').qualify(false).visit(this.alias).qualify(qualify);
            if (this.fieldAliases != null && !emulatedDerivedColumnList) {
                this.toSQLDerivedColumnList(context);
            } else {
                switch (family) {
                    case HSQLDB: 
                    case POSTGRES: {
                        Q o = this.wrapped;
                        if (!context.declareTables() || !(o instanceof ArrayTable)) break;
                        ArrayTable table = (ArrayTable)o;
                        context.sql('(');
                        Tools.fieldNames(context, table.fields());
                        context.sql(')');
                        break;
                    }
                }
            }
            if (this.wrapped instanceof TableImpl) {
                context.scopeMarkEnd((QueryPart)this.wrapping);
            }
            context.declareAliases(true);
        } else {
            context.qualify(false).visit(this.alias).qualify(qualify);
        }
    }

    static void toSQLAs(Context<?> context) {
        if (SUPPORT_AS_REQUIRED.contains((Object)context.family())) {
            context.sql(' ').visit(Keywords.K_AS);
        }
    }

    private void toSQLWrapped(Context<?> context) {
        context.sql(this.wrapInParentheses ? "(" : "").visit((QueryPart)this.wrapped).sql(this.wrapInParentheses ? ")" : "");
    }

    private void toSQLDerivedColumnList(Context<?> context) {
        String separator = "";
        context.sql('(');
        for (int i = 0; i < this.fieldAliases.length; ++i) {
            context.sql(separator);
            context.visit(this.fieldAliases[i]);
            separator = ", ";
        }
        context.sql(')');
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        if (ctx.declareFields() || ctx.declareTables()) {
            if (this.wrapped instanceof Table) {
                return CLAUSES_TABLE_ALIAS;
            }
            return CLAUSES_FIELD_ALIAS;
        }
        if (this.wrapped instanceof Table) {
            return CLAUSES_TABLE_REFERENCE;
        }
        return CLAUSES_FIELD_REFERENCE;
    }

    @Override
    public final boolean declaresFields() {
        return true;
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }
}

