/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jooq.Catalog;
import org.jooq.Configuration;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.Table;
import org.jooq.UniqueKey;
import org.jooq.impl.AbstractMeta;

final class CatalogMetaImpl
extends AbstractMeta {
    private static final long serialVersionUID = 7582210274970452691L;
    private final Configuration configuration;
    private final Catalog[] catalogs;

    CatalogMetaImpl(Configuration configuration, Catalog[] catalogs) {
        this.configuration = configuration;
        this.catalogs = catalogs;
    }

    @Override
    public final List<Catalog> getCatalogs() {
        return Collections.unmodifiableList(Arrays.asList(this.catalogs));
    }

    @Override
    public final List<Schema> getSchemas() {
        ArrayList<Schema> result = new ArrayList<Schema>();
        for (Catalog catalog : this.catalogs) {
            result.addAll(catalog.getSchemas());
        }
        return result;
    }

    @Override
    public final List<Table<?>> getTables() {
        ArrayList result = new ArrayList();
        for (Catalog catalog : this.catalogs) {
            for (Schema schema : catalog.getSchemas()) {
                result.addAll(schema.getTables());
            }
        }
        return result;
    }

    @Override
    public final List<Sequence<?>> getSequences() {
        ArrayList result = new ArrayList();
        for (Catalog catalog : this.catalogs) {
            for (Schema schema : catalog.getSchemas()) {
                result.addAll(schema.getSequences());
            }
        }
        return result;
    }

    @Override
    public final List<UniqueKey<?>> getPrimaryKeys() {
        ArrayList result = new ArrayList();
        for (Catalog catalog : this.catalogs) {
            for (Schema schema : catalog.getSchemas()) {
                for (Table<?> table : schema.getTables()) {
                    if (table.getPrimaryKey() == null) continue;
                    result.add(table.getPrimaryKey());
                }
            }
        }
        return result;
    }
}

