/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.hadoop.ozone.s3.commontypes.IsoDateAdapter;
import org.apache.hadoop.ozone.s3.endpoint.S3Owner;
import org.apache.hadoop.ozone.s3.util.S3StorageType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="ListMultipartUploadsResult", namespace="http://s3.amazonaws.com/doc/2006-03-01/")
public class ListMultipartUploadsResult {
    @XmlElement(name="Bucket")
    private String bucket;
    @XmlElement(name="KeyMarker")
    private String keyMarker;
    @XmlElement(name="UploadIdMarker")
    private String uploadIdMarker;
    @XmlElement(name="NextKeyMarker")
    private String nextKeyMarker;
    @XmlElement(name="Prefix")
    private String prefix;
    @XmlElement(name="NextUploadIdMarker")
    private String nextUploadIdMarker;
    @XmlElement(name="MaxUploads")
    private int maxUploads = 1000;
    @XmlElement(name="IsTruncated")
    private boolean isTruncated = false;
    @XmlElement(name="Upload")
    private List<Upload> uploads = new ArrayList<Upload>();

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getKeyMarker() {
        return this.keyMarker;
    }

    public void setKeyMarker(String keyMarker) {
        this.keyMarker = keyMarker;
    }

    public String getUploadIdMarker() {
        return this.uploadIdMarker;
    }

    public void setUploadIdMarker(String uploadIdMarker) {
        this.uploadIdMarker = uploadIdMarker;
    }

    public String getNextKeyMarker() {
        return this.nextKeyMarker;
    }

    public void setNextKeyMarker(String nextKeyMarker) {
        this.nextKeyMarker = nextKeyMarker;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getNextUploadIdMarker() {
        return this.nextUploadIdMarker;
    }

    public void setNextUploadIdMarker(String nextUploadIdMarker) {
        this.nextUploadIdMarker = nextUploadIdMarker;
    }

    public int getMaxUploads() {
        return this.maxUploads;
    }

    public void setMaxUploads(int maxUploads) {
        this.maxUploads = maxUploads;
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public void setTruncated(boolean truncated) {
        this.isTruncated = truncated;
    }

    public List<Upload> getUploads() {
        return this.uploads;
    }

    public void setUploads(List<Upload> uploads) {
        this.uploads = uploads;
    }

    public void addUpload(Upload upload) {
        this.uploads.add(upload);
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlRootElement(name="Upload")
    public static class Upload {
        @XmlElement(name="Key")
        private String key;
        @XmlElement(name="UploadId")
        private String uploadId;
        @XmlElement(name="Owner")
        private S3Owner owner = S3Owner.NOT_SUPPORTED_OWNER;
        @XmlElement(name="Initiator")
        private S3Owner initiator = S3Owner.NOT_SUPPORTED_OWNER;
        @XmlElement(name="StorageClass")
        private String storageClass = "STANDARD";
        @XmlJavaTypeAdapter(value=IsoDateAdapter.class)
        @XmlElement(name="Initiated")
        private Instant initiated;

        public Upload() {
        }

        public Upload(String key, String uploadId, Instant initiated) {
            this.key = key;
            this.uploadId = uploadId;
            this.initiated = initiated;
        }

        public Upload(String key, String uploadId, Instant initiated, S3StorageType storageClass) {
            this.key = key;
            this.uploadId = uploadId;
            this.initiated = initiated;
            this.storageClass = storageClass.toString();
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getUploadId() {
            return this.uploadId;
        }

        public void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public S3Owner getOwner() {
            return this.owner;
        }

        public void setOwner(S3Owner owner) {
            this.owner = owner;
        }

        public S3Owner getInitiator() {
            return this.initiator;
        }

        public void setInitiator(S3Owner initiator) {
            this.initiator = initiator;
        }

        public String getStorageClass() {
            return this.storageClass;
        }

        public void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public Instant getInitiated() {
            return this.initiated;
        }

        public void setInitiated(Instant initiated) {
            this.initiated = initiated;
        }
    }
}

