/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="Tagging", namespace="http://s3.amazonaws.com/doc/2006-03-01/")
public class S3Tagging {
    @XmlElement(name="TagSet")
    private TagSet tagSet;

    public S3Tagging() {
    }

    public S3Tagging(TagSet tagSet) {
        this.tagSet = tagSet;
    }

    public TagSet getTagSet() {
        return this.tagSet;
    }

    public void setTagSet(TagSet tagSet) {
        this.tagSet = tagSet;
    }

    public static S3Tagging fromMap(Map<String, String> tagMap) {
        List<Tag> tags = tagMap.entrySet().stream().map(tagEntry -> new Tag((String)tagEntry.getKey(), (String)tagEntry.getValue())).collect(Collectors.toList());
        return new S3Tagging(new TagSet(tags));
    }

    public void validate() {
        if (this.tagSet == null) {
            throw new IllegalArgumentException("TagSet needs to be specified");
        }
        if (this.tagSet.getTags().isEmpty()) {
            throw new IllegalArgumentException("Tags need to be specified and cannot be empty");
        }
        for (Tag tag : this.tagSet.getTags()) {
            if (tag.getKey() == null) {
                throw new IllegalArgumentException("Some tag keys are not specified");
            }
            if (tag.getValue() != null) continue;
            throw new IllegalArgumentException("Tag value for tag " + tag.getKey() + " is not specified");
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlRootElement(name="Tag")
    public static class Tag {
        @XmlElement(name="Key")
        private String key;
        @XmlElement(name="Value")
        private String value;

        public Tag() {
        }

        public Tag(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlRootElement(name="TagSet")
    public static class TagSet {
        @XmlElement(name="Tag")
        private List<Tag> tags = new ArrayList<Tag>();

        public TagSet() {
        }

        public TagSet(List<Tag> tags) {
            this.tags = tags;
        }

        public List<Tag> getTags() {
            return this.tags;
        }

        public void setTags(List<Tag> tags) {
            this.tags = tags;
        }
    }
}

