/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.OzoneFsServerDefaults;
import org.apache.hadoop.ozone.OzoneManagerVersion;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public final class ServiceInfo {
    private HddsProtos.NodeType nodeType;
    private String hostname;
    private OzoneManagerVersion omVersion;
    private Map<OzoneManagerProtocolProtos.ServicePort.Type, Integer> ports;
    private OzoneManagerProtocolProtos.OMRoleInfo omRoleInfo;
    private OzoneFsServerDefaults serverDefaults;

    public ServiceInfo() {
    }

    private ServiceInfo(HddsProtos.NodeType nodeType, String hostname, List<OzoneManagerProtocolProtos.ServicePort> portList, OzoneManagerVersion omVersion, OzoneManagerProtocolProtos.OMRoleInfo omRole) {
        this(nodeType, hostname, portList, omVersion, omRole, null);
    }

    private ServiceInfo(HddsProtos.NodeType nodeType, String hostname, List<OzoneManagerProtocolProtos.ServicePort> portList, OzoneManagerVersion omVersion, OzoneManagerProtocolProtos.OMRoleInfo omRole, OzoneFsServerDefaults serverDefaults) {
        Preconditions.checkNotNull((Object)nodeType);
        Preconditions.checkNotNull((Object)hostname);
        this.nodeType = nodeType;
        this.hostname = hostname;
        this.omVersion = omVersion;
        this.ports = new HashMap<OzoneManagerProtocolProtos.ServicePort.Type, Integer>();
        for (OzoneManagerProtocolProtos.ServicePort port : portList) {
            this.ports.put(port.getType(), port.getValue());
        }
        this.omRoleInfo = omRole;
        this.serverDefaults = serverDefaults;
    }

    public HddsProtos.NodeType getNodeType() {
        return this.nodeType;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Map<OzoneManagerProtocolProtos.ServicePort.Type, Integer> getPorts() {
        return this.ports;
    }

    @JsonIgnore
    public int getPort(OzoneManagerProtocolProtos.ServicePort.Type type) {
        return this.ports.get(type);
    }

    @JsonIgnore
    public String getServiceAddress(OzoneManagerProtocolProtos.ServicePort.Type portType) {
        return this.hostname + ":" + this.getPort(portType);
    }

    @JsonIgnore
    public OzoneManagerProtocolProtos.OMRoleInfo getOmRoleInfo() {
        return this.omRoleInfo;
    }

    @JsonIgnore
    public OzoneFsServerDefaults getServerDefaults() {
        return this.serverDefaults;
    }

    @JsonIgnore
    public OzoneManagerProtocolProtos.ServiceInfo getProtobuf() {
        OzoneManagerProtocolProtos.ServiceInfo.Builder builder = OzoneManagerProtocolProtos.ServiceInfo.newBuilder();
        ArrayList<OzoneManagerProtocolProtos.ServicePort> servicePorts = new ArrayList<OzoneManagerProtocolProtos.ServicePort>();
        for (Map.Entry<OzoneManagerProtocolProtos.ServicePort.Type, Integer> entry : this.ports.entrySet()) {
            servicePorts.add(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(entry.getKey()).setValue(entry.getValue().intValue()).build());
        }
        builder.setNodeType(this.nodeType).setHostname(this.hostname).addAllServicePorts(servicePorts);
        if (this.omVersion != null) {
            builder.setOMVersion(this.omVersion.toProtoValue());
        }
        if (this.nodeType == HddsProtos.NodeType.OM && this.omRoleInfo != null) {
            builder.setOmRole(this.omRoleInfo);
        }
        if (this.serverDefaults != null) {
            builder.setServerDefaults(this.serverDefaults.getProtobuf());
        }
        return builder.build();
    }

    @JsonIgnore
    public static ServiceInfo getFromProtobuf(OzoneManagerProtocolProtos.ServiceInfo serviceInfo) {
        return new ServiceInfo(serviceInfo.getNodeType(), serviceInfo.getHostname(), serviceInfo.getServicePortsList(), OzoneManagerVersion.fromProtoValue((int)serviceInfo.getOMVersion()), serviceInfo.hasOmRole() ? serviceInfo.getOmRole() : null, serviceInfo.hasServerDefaults() ? OzoneFsServerDefaults.getFromProtobuf(serviceInfo.getServerDefaults()) : null);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private HddsProtos.NodeType node;
        private String host;
        private List<OzoneManagerProtocolProtos.ServicePort> portList = new ArrayList<OzoneManagerProtocolProtos.ServicePort>();
        private OzoneManagerProtocolProtos.OMRoleInfo omRoleInfo;
        private OzoneManagerVersion omVersion;
        private OzoneFsServerDefaults serverDefaults;

        public OzoneManagerVersion getOmVersion() {
            return this.omVersion;
        }

        public Builder setOmVersion(OzoneManagerVersion omClientProtocolVer) {
            this.omVersion = omClientProtocolVer;
            return this;
        }

        public Builder setNodeType(HddsProtos.NodeType nodeType) {
            this.node = nodeType;
            return this;
        }

        public Builder setHostname(String hostname) {
            this.host = hostname;
            return this;
        }

        public Builder addServicePort(OzoneManagerProtocolProtos.ServicePort servicePort) {
            this.portList.add(servicePort);
            return this;
        }

        public Builder setOmRoleInfo(OzoneManagerProtocolProtos.OMRoleInfo omRole) {
            this.omRoleInfo = omRole;
            return this;
        }

        public Builder setServerDefaults(OzoneFsServerDefaults defaults) {
            this.serverDefaults = defaults;
            return this;
        }

        public ServiceInfo build() {
            return new ServiceInfo(this.node, this.host, this.portList, this.omVersion, this.omRoleInfo, this.serverDefaults);
        }
    }
}

