/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.bucket;

import java.io.IOException;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.ozone.OzoneIllegalArgumentException;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.ShellReplicationOptions;
import org.apache.hadoop.ozone.shell.bucket.BucketHandler;
import picocli.CommandLine;

@CommandLine.Command(name="set-replication-config", description={"Set replication config on bucket"})
public class SetReplicationConfigHandler
extends BucketHandler {
    @CommandLine.Mixin
    private ShellReplicationOptions replication;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        ReplicationConfig replicationConfig = this.replication.fromParams((ConfigurationSource)this.getConf()).orElseThrow(() -> new OzoneIllegalArgumentException("Replication type and config must be specified."));
        String volumeName = address.getVolumeName();
        String bucketName = address.getBucketName();
        OzoneBucket bucket = client.getObjectStore().getVolume(volumeName).getBucket(bucketName);
        bucket.setReplicationConfig(replicationConfig);
    }
}

