/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.s3;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.s3.S3Handler;
import org.apache.hadoop.security.UserGroupInformation;
import picocli.CommandLine;

@CommandLine.Command(name="revokesecret", description={"Revoke s3 secret for current user"})
public class RevokeS3SecretHandler
extends S3Handler {
    @CommandLine.Option(names={"-u"}, description={"Specify the user name to perform the operation on (admins only)'"})
    private String username;
    @CommandLine.Option(names={"-y"}, description={"Continue without interactive user confirmation"})
    private boolean yes;

    @Override
    protected boolean isApplicable() {
        return this.securityEnabled();
    }

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        if (this.username == null || this.username.isEmpty()) {
            this.username = UserGroupInformation.getCurrentUser().getUserName();
        }
        if (!this.yes) {
            this.out().print("Enter 'y' to confirm S3 secret revocation for '" + this.username + "': ");
            this.out().flush();
            Scanner scanner = new Scanner(new InputStreamReader(System.in, StandardCharsets.UTF_8));
            String confirmation = scanner.next().trim().toLowerCase();
            if (!confirmation.equals("y")) {
                this.out().println("Operation cancelled.");
                return;
            }
        }
        client.getObjectStore().revokeS3Secret(this.username);
        this.out().println("S3 secret revoked.");
    }
}

