/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.snapshot;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.shell.Handler;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.bucket.BucketUri;
import org.apache.hadoop.ozone.snapshot.SnapshotDiffReportOzone;
import org.apache.hadoop.ozone.snapshot.SnapshotDiffResponse;
import picocli.CommandLine;

@CommandLine.Command(name="diff", aliases={"snapshotDiff"}, description={"Get the differences between two snapshots"})
public class SnapshotDiffHandler
extends Handler {
    @CommandLine.Mixin
    private BucketUri snapshotPath;
    @CommandLine.Parameters(description={"from snapshot name"}, index="1")
    private String fromSnapshot;
    @CommandLine.Parameters(description={"to snapshot name"}, index="2")
    private String toSnapshot;
    @CommandLine.Option(names={"-t", "--token"}, description={"continuation token for next page (optional)"})
    private String token;
    @CommandLine.Option(names={"-p", "--page-size"}, description={"number of diff entries to be returned in the response"}, defaultValue="1000", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private int pageSize;
    @CommandLine.Option(names={"--ffd", "--force-full-diff"}, description={"perform full diff of snapshot without using optimised DAG based pruning approach (optional)"}, hidden=true)
    private boolean forceFullDiff;
    @CommandLine.Option(names={"-c", "--cancel"}, description={"Request to cancel a running SnapshotDiff job. If the job is not IN_PROGRESS, the request will fail."}, defaultValue="false")
    private boolean cancel;
    @CommandLine.Option(names={"--dnld", "--disable-native-libs-diff"}, description={"perform diff of snapshot without using native libs (optional)"}, hidden=true)
    private boolean diffDisableNativeLibs;
    @CommandLine.Option(names={"--json"}, defaultValue="false", description={"Format output as JSON"})
    private boolean json;

    @Override
    protected OzoneAddress getAddress() {
        return this.snapshotPath.getValue();
    }

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        String volumeName = this.snapshotPath.getValue().getVolumeName();
        String bucketName = this.snapshotPath.getValue().getBucketName();
        OmUtils.validateSnapshotName((String)this.fromSnapshot);
        OmUtils.validateSnapshotName((String)this.toSnapshot);
        if (this.cancel) {
            this.cancelSnapshotDiff(client.getObjectStore(), volumeName, bucketName);
        } else {
            this.getSnapshotDiff(client.getObjectStore(), volumeName, bucketName);
        }
    }

    private void getSnapshotDiff(ObjectStore store, String volumeName, String bucketName) throws IOException {
        SnapshotDiffResponse diffResponse = store.snapshotDiff(volumeName, bucketName, this.fromSnapshot, this.toSnapshot, this.token, this.pageSize, this.forceFullDiff, this.diffDisableNativeLibs);
        try (PrintWriter writer = this.out();){
            if (this.json) {
                writer.println(JsonUtils.toJsonStringWithDefaultPrettyPrinter((Object)this.getJsonObject(diffResponse)));
            } else {
                writer.println(diffResponse);
            }
        }
    }

    private void cancelSnapshotDiff(ObjectStore store, String volumeName, String bucketName) throws IOException {
        try (PrintWriter writer = this.out();){
            writer.println(store.cancelSnapshotDiff(volumeName, bucketName, this.fromSnapshot, this.toSnapshot));
        }
    }

    private ObjectNode getJsonObject(SnapshotDiffResponse diffResponse) {
        ObjectNode diffResponseNode = JsonUtils.createObjectNode(null);
        diffResponseNode.set("snapshotDiffReport", (JsonNode)this.getJsonObject(diffResponse.getSnapshotDiffReport()));
        diffResponseNode.put("jobStatus", diffResponse.getJobStatus().name());
        if (diffResponse.getWaitTimeInMs() != 0L) {
            diffResponseNode.put("waitTimeInMs", diffResponse.getWaitTimeInMs());
        }
        if (StringUtils.isNotEmpty((CharSequence)diffResponse.getReason())) {
            diffResponseNode.put("reason", diffResponse.getReason());
        }
        return diffResponseNode;
    }

    private ObjectNode getJsonObject(SnapshotDiffReportOzone diffReportOzone) {
        ObjectNode diffReportNode = JsonUtils.createObjectNode(null);
        diffReportNode.put("volumeName", diffReportOzone.getVolumeName());
        diffReportNode.put("bucketName", diffReportOzone.getBucketName());
        diffReportNode.put("fromSnapshot", diffReportOzone.getFromSnapshot());
        diffReportNode.put("toSnapshot", diffReportOzone.getLaterSnapshotName());
        ArrayNode resArray = JsonUtils.createArrayNode();
        diffReportOzone.getDiffList().forEach(diffReportEntry -> resArray.add((JsonNode)this.getJsonObject((SnapshotDiffReport.DiffReportEntry)diffReportEntry)));
        diffReportNode.set("diffList", (JsonNode)resArray);
        if (StringUtils.isNotEmpty((CharSequence)diffReportOzone.getToken())) {
            diffReportNode.put("nextToken", diffReportOzone.getToken());
        }
        return diffReportNode;
    }

    private ObjectNode getJsonObject(SnapshotDiffReport.DiffReportEntry diffReportEntry) {
        ObjectNode diffReportNode = JsonUtils.createObjectNode(null);
        diffReportNode.put("diffType", diffReportEntry.getType().getLabel());
        diffReportNode.put("sourcePath", this.getPathString(diffReportEntry.getSourcePath()));
        if (diffReportEntry.getTargetPath() != null) {
            diffReportNode.put("targetPath", this.getPathString(diffReportEntry.getTargetPath()));
        }
        return diffReportNode;
    }

    private String getPathString(byte[] path) {
        String pathStr = DFSUtilClient.bytes2String((byte[])path);
        if (pathStr.isEmpty()) {
            return ".";
        }
        return "./" + pathStr;
    }
}

