/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.tenant;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.om.helpers.TenantStateList;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.tenant.TenantHandler;
import picocli.CommandLine;

@CommandLine.Command(name="list", aliases={"ls"}, description={"List tenants"})
public class TenantListHandler
extends TenantHandler {
    @CommandLine.Option(names={"--json", "-j"}, description={"Print detailed result in JSON"})
    private boolean printJson;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        TenantStateList tenantStateList = client.getObjectStore().listTenant();
        if (!this.printJson) {
            tenantStateList.getTenantStateList().forEach(tenantState -> this.out().println(tenantState.getTenantId()));
        } else {
            ArrayNode resArray = JsonUtils.createArrayNode();
            tenantStateList.getTenantStateList().forEach(tenantState -> {
                ObjectNode obj = JsonUtils.createObjectNode(null);
                obj.put("tenantId", tenantState.getTenantId());
                obj.put("bucketNamespaceName", tenantState.getBucketNamespaceName());
                obj.put("userRoleName", tenantState.getUserRoleName());
                obj.put("adminRoleName", tenantState.getAdminRoleName());
                obj.put("bucketNamespacePolicyName", tenantState.getBucketNamespacePolicyName());
                obj.put("bucketPolicyName", tenantState.getBucketPolicyName());
                resArray.add((JsonNode)obj);
            });
            String jsonString = JsonUtils.toJsonStringWithDefaultPrettyPrinter((Object)resArray);
            this.out().println(jsonString);
        }
    }
}

