/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.tenant;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.om.helpers.TenantUserList;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.s3.S3Handler;
import picocli.CommandLine;

@CommandLine.Command(name="list", aliases={"ls"}, description={"List users in a tenant"})
public class TenantListUsersHandler
extends S3Handler {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Parameters(description={"Tenant name"}, arity="1..1")
    private String tenantId;
    @CommandLine.Option(names={"--prefix", "-p"}, description={"Filter users with this prefix."})
    private String prefix;
    @CommandLine.Option(names={"--json", "-j"}, description={"Print detailed result in JSON"})
    private boolean printJson;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        TenantUserList usersInTenant = client.getObjectStore().listUsersInTenant(this.tenantId, this.prefix);
        if (!this.printJson) {
            usersInTenant.getUserAccessIds().forEach(accessIdInfo -> this.out().println("- User '" + accessIdInfo.getUserPrincipal() + "' with accessId '" + accessIdInfo.getAccessId() + "'"));
        } else {
            ArrayNode resArray = JsonUtils.createArrayNode();
            usersInTenant.getUserAccessIds().forEach(accessIdInfo -> {
                ObjectNode obj = JsonUtils.createObjectNode(null);
                obj.put("user", accessIdInfo.getUserPrincipal());
                obj.put("accessId", accessIdInfo.getAccessId());
                resArray.add((JsonNode)obj);
            });
            String prettyJsonString = JsonUtils.toJsonStringWithDefaultPrettyPrinter((Object)resArray);
            this.out().println(prettyJsonString);
        }
    }
}

