/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload.mt.operations;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.phoenix.pherf.configuration.Column;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.configuration.Upsert;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.mt.generators.TenantOperationInfo;
import org.apache.phoenix.pherf.workload.mt.operations.BaseOperationSupplier;
import org.apache.phoenix.pherf.workload.mt.operations.OperationStats;
import org.apache.phoenix.pherf.workload.mt.operations.UpsertOperation;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpsertOperationSupplier
extends BaseOperationSupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpsertOperationSupplier.class);
    private ReadWriteLock rwLock = new ReentrantReadWriteLock();

    public UpsertOperationSupplier(PhoenixUtil phoenixUtil, DataModel model, Scenario scenario) {
        super(phoenixUtil, model, scenario);
    }

    @Override
    public Function<TenantOperationInfo, OperationStats> get() {
        return new Function<TenantOperationInfo, OperationStats>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OperationStats apply(TenantOperationInfo input) {
                Preconditions.checkNotNull(input);
                int batchSize = UpsertOperationSupplier.this.loadProfile.getBatchSize();
                boolean useBatchApi = batchSize != 0;
                int rowCount = useBatchApi ? batchSize : 1;
                UpsertOperation operation = (UpsertOperation)input.getOperation();
                Upsert upsert = operation.getUpsert();
                String tenantGroup = input.getTenantGroupId();
                String opGroup = input.getOperationGroupId();
                String tableName = input.getTableName();
                String scenarioName = input.getScenarioName();
                boolean isTenantGroupGlobal = tenantGroup.compareTo("GLOBAL") == 0;
                String tenantId = isTenantGroupGlobal || upsert.isUseGlobalConnection() ? null : input.getTenantId();
                String opName = String.format("%s:%s:%s:%s:%s", scenarioName, tableName, opGroup, tenantGroup, input.getTenantId());
                long rowsCreated = 0L;
                long startTime = 0L;
                int status = 0;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try (Connection connection = UpsertOperationSupplier.this.phoenixUtil.getConnection(tenantId);){
                    if (upsert.getColumn().isEmpty()) {
                        UpsertOperationSupplier.this.rwLock.writeLock().lock();
                        try {
                            if (upsert.getColumn().isEmpty()) {
                                LOGGER.info("Fetching columns metadata from db for operation : " + opName);
                                List<Column> allCols = UpsertOperationSupplier.this.phoenixUtil.getColumnsFromPhoenix(UpsertOperationSupplier.this.scenario.getSchemaName(), UpsertOperationSupplier.this.scenario.getTableNameWithoutSchemaName(), connection);
                                upsert.setColumn(allCols);
                            }
                        }
                        finally {
                            UpsertOperationSupplier.this.rwLock.writeLock().unlock();
                        }
                    }
                    String sql = UpsertOperationSupplier.this.phoenixUtil.buildSql(upsert.getColumn(), tableName);
                    LOGGER.info("Operation " + opName + " executing " + sql);
                    startTime = EnvironmentEdgeManager.currentTimeMillis();
                    PreparedStatement stmt = null;
                    try {
                        stmt = connection.prepareStatement(sql);
                        for (long i = (long)rowCount; i > 0L; --i) {
                            stmt = UpsertOperationSupplier.this.phoenixUtil.buildStatement(UpsertOperationSupplier.this.rulesApplier, UpsertOperationSupplier.this.scenario, upsert.getColumn(), stmt, simpleDateFormat);
                            if (useBatchApi) {
                                stmt.addBatch();
                                continue;
                            }
                            rowsCreated += (long)stmt.executeUpdate();
                        }
                    }
                    catch (SQLException e) {
                        throw e;
                    }
                    finally {
                        if (!useBatchApi && stmt != null) {
                            stmt.close();
                        }
                        if (connection != null) {
                            if (useBatchApi && stmt != null) {
                                int[] results = stmt.executeBatch();
                                for (int x = 0; x < results.length; ++x) {
                                    int result = results[x];
                                    if (result < 1) {
                                        String msg = "Failed to write update in batch (update count=" + result + ")";
                                        throw new RuntimeException(msg);
                                    }
                                    rowsCreated += (long)result;
                                }
                                stmt.close();
                            }
                            try {
                                connection.commit();
                                long duration = EnvironmentEdgeManager.currentTimeMillis() - startTime;
                                LOGGER.info("Writer ( " + Thread.currentThread().getName() + ") committed Final Batch. Duration (" + duration + ") Ms");
                                connection.close();
                            }
                            catch (SQLException e) {
                                LOGGER.error("Error when closing/committing", (Throwable)e);
                            }
                        }
                    }
                }
                catch (SQLException sqle) {
                    LOGGER.error("Operation " + opName + " failed with exception ", (Throwable)sqle);
                    status = -1;
                }
                catch (Exception e) {
                    LOGGER.error("Operation " + opName + " failed with exception ", (Throwable)e);
                    status = -1;
                }
                long totalDuration = EnvironmentEdgeManager.currentTimeMillis() - startTime;
                return new OperationStats(input, startTime, status, rowsCreated, totalDuration);
            }
        };
    }
}

