/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.ImmutableHTableDescriptor;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.BuilderStyleTest;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={ClientTests.class, SmallTests.class})
public class TestImmutableHTableDescriptor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestImmutableHTableDescriptor.class);
    @Rule
    public TestName name = new TestName();
    private static final List<Consumer<ImmutableHTableDescriptor>> TEST_FUNCTION = Arrays.asList(htd -> htd.setValue("a", "a"), htd -> htd.setValue(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"a")), htd -> htd.setValue(new Bytes(Bytes.toBytes((String)"a")), new Bytes(Bytes.toBytes((String)"a"))), htd -> htd.setCompactionEnabled(false), htd -> htd.setConfiguration("aaa", "ccc"), htd -> htd.setDurability(Durability.USE_DEFAULT), htd -> htd.setFlushPolicyClassName("class"), htd -> htd.setMaxFileSize(123L), htd -> htd.setMemStoreFlushSize(123123123L), htd -> htd.setNormalizationEnabled(false), htd -> htd.setPriority(123), htd -> htd.setReadOnly(true), htd -> htd.setRegionMemstoreReplication(true), htd -> htd.setRegionReplication(123), htd -> htd.setRegionSplitPolicyClassName("class"), htd -> htd.addFamily(new HColumnDescriptor(Bytes.toBytes((String)"fm"))), htd -> htd.remove(new Bytes(Bytes.toBytes((String)"aaa"))), htd -> htd.remove("aaa"), htd -> htd.remove(Bytes.toBytes((String)"aaa")), htd -> htd.removeConfiguration("xxx"), htd -> htd.removeFamily(Bytes.toBytes((String)"fm")), htd -> {
        try {
            htd.addCoprocessor("xxx");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    });

    @Test
    public void testImmutable() {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        ImmutableHTableDescriptor immutableHtd = new ImmutableHTableDescriptor(htd);
        TEST_FUNCTION.forEach(f -> {
            try {
                f.accept(immutableHtd);
                Assert.fail((String)"ImmutableHTableDescriptor can't be modified!!!");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        });
    }

    @Test
    public void testImmutableHColumnDescriptor() {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        htd.addFamily(new HColumnDescriptor(Bytes.toBytes((String)"family")));
        ImmutableHTableDescriptor immutableHtd = new ImmutableHTableDescriptor(htd);
        for (HColumnDescriptor hcd : immutableHtd.getColumnFamilies()) {
            this.assertReadOnly(hcd);
        }
        for (HColumnDescriptor hcd : immutableHtd.getFamilies()) {
            this.assertReadOnly(hcd);
        }
    }

    private void assertReadOnly(HColumnDescriptor hcd) {
        try {
            hcd.setBlocksize(10);
            Assert.fail((String)"ImmutableHColumnDescriptor can't be modified!!!");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testClassMethodsAreBuilderStyle() {
        BuilderStyleTest.assertClassesAreBuilderStyle(ImmutableHTableDescriptor.class);
    }
}

