/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionLoadStats;
import org.apache.hadoop.hbase.client.ResultStatsUtil;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.StatisticTrackable;
import org.apache.hadoop.hbase.client.backoff.ServerStatistics;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, SmallTests.class})
public class TestResultStatsUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestResultStatsUtil.class);
    private static final RegionLoadStats regionLoadStats = new RegionLoadStats(100, 10, 90);
    private static final byte[] regionName = new byte[]{80};
    private static final ServerName server = ServerName.parseServerName((String)"3.1.yg.n,50,1");

    @Test
    public void testUpdateStats() {
        ServerStatisticTracker serverStatisticTracker = new ServerStatisticTracker();
        ResultStatsUtil.updateStats((StatisticTrackable)serverStatisticTracker, (ServerName)server, (byte[])regionName, (RegionLoadStats)regionLoadStats);
        ServerStatistics stats = serverStatisticTracker.getStats(server);
        Assert.assertEquals((long)TestResultStatsUtil.regionLoadStats.memstoreLoad, (long)stats.getStatsForRegion(regionName).getMemStoreLoadPercent());
        Assert.assertEquals((long)TestResultStatsUtil.regionLoadStats.compactionPressure, (long)stats.getStatsForRegion(regionName).getCompactionPressure());
        Assert.assertEquals((long)TestResultStatsUtil.regionLoadStats.heapOccupancy, (long)stats.getStatsForRegion(regionName).getHeapOccupancyPercent());
    }

    @Test
    public void testUpdateStatsRegionNameNull() {
        ServerStatisticTracker serverStatisticTracker = new ServerStatisticTracker();
        ResultStatsUtil.updateStats((StatisticTrackable)serverStatisticTracker, (ServerName)server, null, (RegionLoadStats)regionLoadStats);
        ServerStatistics stats = serverStatisticTracker.getStats(server);
        Assert.assertNull((Object)stats);
    }

    @Test
    public void testUpdateStatsStatsNull() {
        ServerStatisticTracker serverStatisticTracker = new ServerStatisticTracker();
        ResultStatsUtil.updateStats((StatisticTrackable)serverStatisticTracker, (ServerName)server, (byte[])regionName, null);
        ServerStatistics stats = serverStatisticTracker.getStats(server);
        Assert.assertNull((Object)stats);
    }

    @Test
    public void testUpdateStatsTrackerNull() {
        ServerStatisticTracker serverStatisticTracker = new ServerStatisticTracker();
        ResultStatsUtil.updateStats(null, (ServerName)server, (byte[])regionName, (RegionLoadStats)regionLoadStats);
        ServerStatistics stats = serverStatisticTracker.getStats(server);
        Assert.assertNull((Object)stats);
    }
}

