/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestQuotaGlobalsSettingsBypass {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestQuotaGlobalsSettingsBypass.class);

    @Test
    public void testMerge() throws IOException {
        QuotaSettingsFactory.QuotaGlobalsSettingsBypass orig = new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("joe", null, null, null, true);
        Assert.assertFalse((boolean)orig.merge((QuotaSettings)new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("joe", null, null, null, false)).getBypass());
    }

    @Test
    public void testInvalidMerges() throws IOException {
        QuotaSettingsFactory.QuotaGlobalsSettingsBypass userBypass = new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("joe", null, null, null, true);
        QuotaSettingsFactory.QuotaGlobalsSettingsBypass tableBypass = new QuotaSettingsFactory.QuotaGlobalsSettingsBypass(null, TableName.valueOf((String)"table"), null, null, true);
        QuotaSettingsFactory.QuotaGlobalsSettingsBypass namespaceBypass = new QuotaSettingsFactory.QuotaGlobalsSettingsBypass(null, null, "ns", null, true);
        QuotaSettingsFactory.QuotaGlobalsSettingsBypass regionServerBypass = new QuotaSettingsFactory.QuotaGlobalsSettingsBypass(null, null, null, "all", true);
        QuotaSettingsFactory.QuotaGlobalsSettingsBypass userOnTableBypass = new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("joe", TableName.valueOf((String)"table"), null, null, true);
        QuotaSettingsFactory.QuotaGlobalsSettingsBypass userOnNamespaceBypass = new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("joe", null, "ns", null, true);
        QuotaSettingsFactory.QuotaGlobalsSettingsBypass userOnRegionServerBypass = new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("joe", null, null, "all", true);
        Assert.assertTrue((boolean)userBypass.merge((QuotaSettings)userBypass).getBypass());
        this.expectFailure((QuotaSettings)userBypass, (QuotaSettings)new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("frank", null, null, null, false));
        this.expectFailure((QuotaSettings)userBypass, (QuotaSettings)tableBypass);
        this.expectFailure((QuotaSettings)userBypass, (QuotaSettings)namespaceBypass);
        this.expectFailure((QuotaSettings)userBypass, (QuotaSettings)regionServerBypass);
        this.expectFailure((QuotaSettings)userBypass, (QuotaSettings)userOnTableBypass);
        this.expectFailure((QuotaSettings)userBypass, (QuotaSettings)userOnNamespaceBypass);
        this.expectFailure((QuotaSettings)userBypass, (QuotaSettings)userOnRegionServerBypass);
        Assert.assertTrue((boolean)tableBypass.merge((QuotaSettings)tableBypass).getBypass());
        this.expectFailure((QuotaSettings)tableBypass, (QuotaSettings)userBypass);
        this.expectFailure((QuotaSettings)tableBypass, (QuotaSettings)new QuotaSettingsFactory.QuotaGlobalsSettingsBypass(null, TableName.valueOf((String)"foo"), null, null, false));
        this.expectFailure((QuotaSettings)tableBypass, (QuotaSettings)namespaceBypass);
        this.expectFailure((QuotaSettings)tableBypass, (QuotaSettings)regionServerBypass);
        this.expectFailure((QuotaSettings)tableBypass, (QuotaSettings)userOnTableBypass);
        this.expectFailure((QuotaSettings)tableBypass, (QuotaSettings)userOnNamespaceBypass);
        this.expectFailure((QuotaSettings)tableBypass, (QuotaSettings)userOnRegionServerBypass);
        Assert.assertTrue((boolean)namespaceBypass.merge((QuotaSettings)namespaceBypass).getBypass());
        this.expectFailure((QuotaSettings)namespaceBypass, (QuotaSettings)userBypass);
        this.expectFailure((QuotaSettings)namespaceBypass, (QuotaSettings)tableBypass);
        this.expectFailure((QuotaSettings)namespaceBypass, (QuotaSettings)regionServerBypass);
        this.expectFailure((QuotaSettings)namespaceBypass, (QuotaSettings)new QuotaSettingsFactory.QuotaGlobalsSettingsBypass(null, null, "sn", null, false));
        this.expectFailure((QuotaSettings)namespaceBypass, (QuotaSettings)userOnTableBypass);
        this.expectFailure((QuotaSettings)namespaceBypass, (QuotaSettings)userOnNamespaceBypass);
        this.expectFailure((QuotaSettings)namespaceBypass, (QuotaSettings)userOnNamespaceBypass);
        Assert.assertTrue((boolean)regionServerBypass.merge((QuotaSettings)regionServerBypass).getBypass());
        this.expectFailure((QuotaSettings)regionServerBypass, (QuotaSettings)userBypass);
        this.expectFailure((QuotaSettings)regionServerBypass, (QuotaSettings)tableBypass);
        this.expectFailure((QuotaSettings)regionServerBypass, (QuotaSettings)namespaceBypass);
        this.expectFailure((QuotaSettings)regionServerBypass, (QuotaSettings)new QuotaSettingsFactory.QuotaGlobalsSettingsBypass(null, null, null, "rs", false));
        this.expectFailure((QuotaSettings)regionServerBypass, (QuotaSettings)userOnTableBypass);
        this.expectFailure((QuotaSettings)regionServerBypass, (QuotaSettings)userOnNamespaceBypass);
        this.expectFailure((QuotaSettings)regionServerBypass, (QuotaSettings)userOnRegionServerBypass);
        Assert.assertTrue((boolean)userOnTableBypass.merge((QuotaSettings)userOnTableBypass).getBypass());
        this.expectFailure((QuotaSettings)userOnTableBypass, (QuotaSettings)userBypass);
        this.expectFailure((QuotaSettings)userOnTableBypass, (QuotaSettings)tableBypass);
        this.expectFailure((QuotaSettings)userOnTableBypass, (QuotaSettings)namespaceBypass);
        this.expectFailure((QuotaSettings)userOnTableBypass, (QuotaSettings)regionServerBypass);
        this.expectFailure((QuotaSettings)userOnTableBypass, (QuotaSettings)new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("frank", TableName.valueOf((String)"foo"), null, null, false));
        this.expectFailure((QuotaSettings)userOnTableBypass, (QuotaSettings)new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("joe", TableName.valueOf((String)"bar"), null, null, false));
        this.expectFailure((QuotaSettings)userOnTableBypass, (QuotaSettings)userOnNamespaceBypass);
        this.expectFailure((QuotaSettings)userOnTableBypass, (QuotaSettings)userOnRegionServerBypass);
        Assert.assertTrue((boolean)userOnNamespaceBypass.merge((QuotaSettings)userOnNamespaceBypass).getBypass());
        this.expectFailure((QuotaSettings)userOnNamespaceBypass, (QuotaSettings)userBypass);
        this.expectFailure((QuotaSettings)userOnNamespaceBypass, (QuotaSettings)tableBypass);
        this.expectFailure((QuotaSettings)userOnNamespaceBypass, (QuotaSettings)namespaceBypass);
        this.expectFailure((QuotaSettings)userOnNamespaceBypass, (QuotaSettings)regionServerBypass);
        this.expectFailure((QuotaSettings)userOnNamespaceBypass, (QuotaSettings)userOnTableBypass);
        this.expectFailure((QuotaSettings)userOnNamespaceBypass, (QuotaSettings)new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("frank", null, "ns", null, false));
        this.expectFailure((QuotaSettings)userOnNamespaceBypass, (QuotaSettings)new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("joe", null, "sn", null, false));
        this.expectFailure((QuotaSettings)userOnNamespaceBypass, (QuotaSettings)userOnRegionServerBypass);
        Assert.assertTrue((boolean)userOnRegionServerBypass.merge((QuotaSettings)userOnRegionServerBypass).getBypass());
        this.expectFailure((QuotaSettings)userOnRegionServerBypass, (QuotaSettings)userBypass);
        this.expectFailure((QuotaSettings)userOnRegionServerBypass, (QuotaSettings)tableBypass);
        this.expectFailure((QuotaSettings)userOnRegionServerBypass, (QuotaSettings)namespaceBypass);
        this.expectFailure((QuotaSettings)userOnRegionServerBypass, (QuotaSettings)regionServerBypass);
        this.expectFailure((QuotaSettings)userOnRegionServerBypass, (QuotaSettings)userOnTableBypass);
        this.expectFailure((QuotaSettings)userOnRegionServerBypass, (QuotaSettings)userOnNamespaceBypass);
        this.expectFailure((QuotaSettings)userOnRegionServerBypass, (QuotaSettings)new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("frank", null, null, "all", false));
        this.expectFailure((QuotaSettings)userOnRegionServerBypass, (QuotaSettings)new QuotaSettingsFactory.QuotaGlobalsSettingsBypass("joe", null, null, "rs", false));
    }

    void expectFailure(QuotaSettings one, QuotaSettings two) throws IOException {
        try {
            one.merge(two);
            Assert.fail((String)("Expected to see an Exception merging " + two + " into " + one));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

