/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import org.apache.hadoop.hbase.procedure2.ProcedureException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ErrorHandlingProtos;
import org.apache.hadoop.hbase.util.ForeignExceptionUtil;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RemoteProcedureException
extends ProcedureException {
    private final String source;

    public RemoteProcedureException(String source, Throwable cause) {
        super(cause);
        assert (source != null);
        assert (cause != null);
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public Exception unwrapRemoteException() {
        Throwable cause = this.getCause();
        if (cause instanceof RemoteException) {
            return ((RemoteException)cause).unwrapRemoteException();
        }
        if (cause instanceof Exception) {
            return (Exception)cause;
        }
        return new Exception(cause);
    }

    public IOException unwrapRemoteIOException() {
        Exception cause = this.unwrapRemoteException();
        if (cause instanceof IOException) {
            return (IOException)cause;
        }
        return new IOException(cause);
    }

    public String toString() {
        String className = this.getCause().getClass().getName();
        return className + " via " + this.getSource() + ":" + this.getLocalizedMessage();
    }

    public static byte[] serialize(String source, Throwable t) {
        return RemoteProcedureException.toProto(source, t).toByteArray();
    }

    public static RemoteProcedureException deserialize(byte[] bytes) throws IOException {
        return RemoteProcedureException.fromProto(ErrorHandlingProtos.ForeignExceptionMessage.parseFrom((byte[])bytes));
    }

    public ErrorHandlingProtos.ForeignExceptionMessage convert() {
        return ForeignExceptionUtil.toProtoForeignException((String)this.getSource(), (Throwable)this.getCause());
    }

    public static ErrorHandlingProtos.ForeignExceptionMessage toProto(String source, Throwable t) {
        return ForeignExceptionUtil.toProtoForeignException((String)source, (Throwable)t);
    }

    public static RemoteProcedureException fromProto(ErrorHandlingProtos.ForeignExceptionMessage eem) {
        return new RemoteProcedureException(eem.getSource(), ForeignExceptionUtil.toException((ErrorHandlingProtos.ForeignExceptionMessage)eem));
    }
}

