/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

public class HKerberos {
    private static final Log LOG = LogFactory.getLog(HKerberos.class);

    public static void tryKerberosKeytabLogin(Configuration conf) {
        if (UserGroupInformation.isSecurityEnabled()) {
            UserGroupInformation loginUser;
            try {
                loginUser = UserGroupInformation.getLoginUser();
            }
            catch (IOException e) {
                LOG.error((Object)("Unable to start attempt to login using Kerberos keytab: " + e.getMessage()));
                return;
            }
            if (!loginUser.hasKerberosCredentials() && !loginUser.isFromKeytab()) {
                String krb5Conf = conf.get("java.security.krb5.conf");
                String krb5Principal = conf.get("hadoop.security.krb5.principal");
                String krb5Keytab = conf.get("hadoop.security.krb5.keytab");
                if (krb5Conf != null && krb5Principal != null && krb5Keytab != null) {
                    LOG.info((Object)"Trying login using Kerberos Keytab");
                    LOG.info((Object)("krb5: Conf      = " + krb5Conf));
                    LOG.info((Object)("krb5: Principal = " + krb5Principal));
                    LOG.info((Object)("krb5: Keytab    = " + krb5Keytab));
                    System.setProperty("java.security.krb5.conf", krb5Conf);
                    try {
                        UserGroupInformation.loginUserFromKeytab((String)krb5Principal, (String)krb5Keytab);
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Unable to perform keytab based kerberos authentication: " + e.getMessage()));
                    }
                }
            }
        }
    }
}

