/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.launcher;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.dag.app.launcher.DagDeleteRunnable;
import org.apache.tez.dag.app.launcher.DeletionTracker;
import org.apache.tez.dag.app.launcher.TaskAttemptFailedRunnable;
import org.apache.tez.dag.app.launcher.VertexDeleteRunnable;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.library.common.TezRuntimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletionTrackerImpl
extends DeletionTracker {
    private static final Logger LOG = LoggerFactory.getLogger(DeletionTrackerImpl.class);
    private Map<NodeId, Integer> nodeIdShufflePortMap = new HashMap<NodeId, Integer>();
    private ExecutorService dagCleanupService;

    public DeletionTrackerImpl(Configuration conf) {
        super(conf);
        this.dagCleanupService = new ThreadPoolExecutor(0, conf.getInt("tez.am.dag.deletion.thread-count-limit", 10), 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ShuffleDeleteTracker #%d").build());
    }

    @Override
    public void dagComplete(TezDAGID dag, JobTokenSecretManager jobTokenSecretManager) {
        super.dagComplete(dag, jobTokenSecretManager);
        for (Map.Entry<NodeId, Integer> entry : this.nodeIdShufflePortMap.entrySet()) {
            NodeId nodeId = entry.getKey();
            int shufflePort = entry.getValue();
            if (shufflePort == -1) continue;
            DagDeleteRunnable dagDeleteRunnable = new DagDeleteRunnable(nodeId, shufflePort, dag, TezRuntimeUtils.getHttpConnectionParams((Configuration)this.conf), jobTokenSecretManager);
            try {
                this.dagCleanupService.submit(dagDeleteRunnable);
            }
            catch (RejectedExecutionException rejectedException) {
                LOG.info("Ignoring deletion request for " + dagDeleteRunnable);
            }
        }
    }

    @Override
    public void taskAttemptFailed(TezTaskAttemptID taskAttemptID, JobTokenSecretManager jobTokenSecretManager, NodeId nodeId) {
        super.taskAttemptFailed(taskAttemptID, jobTokenSecretManager, nodeId);
        if (this.nodeIdShufflePortMap == null || this.nodeIdShufflePortMap.get(nodeId) == null) {
            LOG.warn("Unable to find the shuffle port for shuffle data deletion of failed task attempt.");
            return;
        }
        int shufflePort = this.nodeIdShufflePortMap.get(nodeId);
        if (shufflePort != -1) {
            TaskAttemptFailedRunnable taskAttemptFailedRunnable = new TaskAttemptFailedRunnable(nodeId, shufflePort, taskAttemptID, TezRuntimeUtils.getHttpConnectionParams((Configuration)this.conf), jobTokenSecretManager);
            try {
                this.dagCleanupService.submit(taskAttemptFailedRunnable);
            }
            catch (RejectedExecutionException rejectedException) {
                LOG.info("Ignoring failed task attempt deletion request for " + taskAttemptFailedRunnable);
            }
        }
    }

    @Override
    public void addNodeShufflePort(NodeId nodeId, int port) {
        if (port != -1 && this.nodeIdShufflePortMap.get(nodeId) == null) {
            this.nodeIdShufflePortMap.put(nodeId, port);
        }
    }

    @VisibleForTesting
    Map<NodeId, Integer> getNodeIdShufflePortMap() {
        return this.nodeIdShufflePortMap;
    }

    @Override
    public void shutdown() {
        if (this.dagCleanupService != null) {
            this.dagCleanupService.shutdownNow();
            this.dagCleanupService = null;
        }
        this.nodeIdShufflePortMap = null;
    }

    @Override
    public void vertexComplete(TezVertexID vertex, JobTokenSecretManager jobTokenSecretManager, Set<NodeId> nodeIdList) {
        super.vertexComplete(vertex, jobTokenSecretManager, nodeIdList);
        String vertexId = String.format("%02d", vertex.getId());
        for (NodeId nodeId : nodeIdList) {
            Integer shufflePort = null;
            if (this.nodeIdShufflePortMap != null) {
                shufflePort = this.nodeIdShufflePortMap.get(nodeId);
            }
            if (shufflePort == null) continue;
            VertexDeleteRunnable vertexDeleteRunnable = new VertexDeleteRunnable(vertex, jobTokenSecretManager, nodeId, shufflePort, vertexId, TezRuntimeUtils.getHttpConnectionParams((Configuration)this.conf));
            try {
                this.dagCleanupService.submit(vertexDeleteRunnable);
            }
            catch (RejectedExecutionException rejectedException) {
                LOG.info("Ignoring deletion request for " + vertexDeleteRunnable);
            }
        }
    }
}

