/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.org.roaringbitmap;

import org.apache.pig.org.roaringbitmap.ArrayContainer;
import org.apache.pig.org.roaringbitmap.BitmapContainer;
import org.apache.pig.org.roaringbitmap.Container;
import org.apache.pig.org.roaringbitmap.IntIterator;
import org.apache.pig.org.roaringbitmap.ReverseArrayContainerShortIterator;
import org.apache.pig.org.roaringbitmap.ReverseBitmapContainerShortIterator;
import org.apache.pig.org.roaringbitmap.ReverseRunContainerShortIterator;
import org.apache.pig.org.roaringbitmap.RoaringBitmap;
import org.apache.pig.org.roaringbitmap.RunContainer;
import org.apache.pig.org.roaringbitmap.ShortIterator;
import org.apache.pig.org.roaringbitmap.Util;

public class ReverseIntIteratorFlyweight
implements IntIterator {
    private int hs;
    private ShortIterator iter;
    private ReverseArrayContainerShortIterator arrIter = new ReverseArrayContainerShortIterator();
    private ReverseBitmapContainerShortIterator bitmapIter = new ReverseBitmapContainerShortIterator();
    private ReverseRunContainerShortIterator runIter = new ReverseRunContainerShortIterator();
    private short pos;
    private RoaringBitmap roaringBitmap = null;

    public ReverseIntIteratorFlyweight() {
    }

    public ReverseIntIteratorFlyweight(RoaringBitmap r) {
        this.wrap(r);
    }

    @Override
    public IntIterator clone() {
        try {
            ReverseIntIteratorFlyweight x = (ReverseIntIteratorFlyweight)super.clone();
            if (this.iter != null) {
                x.iter = this.iter.clone();
            }
            return x;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos >= 0;
    }

    @Override
    public int next() {
        int x = this.iter.nextAsInt() | this.hs;
        if (!this.iter.hasNext()) {
            this.pos = (short)(this.pos - 1);
            this.nextContainer();
        }
        return x;
    }

    private void nextContainer() {
        if (this.pos >= 0) {
            Container container = this.roaringBitmap.highLowContainer.getContainerAtIndex(this.pos);
            if (container instanceof BitmapContainer) {
                this.bitmapIter.wrap(((BitmapContainer)container).bitmap);
                this.iter = this.bitmapIter;
            } else if (container instanceof ArrayContainer) {
                this.arrIter.wrap((ArrayContainer)container);
                this.iter = this.arrIter;
            } else {
                this.runIter.wrap((RunContainer)container);
                this.iter = this.runIter;
            }
            this.hs = Util.toIntUnsigned(this.roaringBitmap.highLowContainer.getKeyAtIndex(this.pos)) << 16;
        }
    }

    public void wrap(RoaringBitmap r) {
        this.roaringBitmap = r;
        this.hs = 0;
        this.pos = (short)(this.roaringBitmap.highLowContainer.size() - 1);
        this.nextContainer();
    }
}

