/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.memory.ExecutionMemoryPool;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.StorageMemoryPool;
import org.apache.spark.memory.UnifiedMemoryManager$;
import org.apache.spark.storage.BlockId;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.Tuple4;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001Q4Q\u0001F\u000b\u0001/uA\u0001B\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tQ\u0001\u0011)\u0019!C\u0001S!A\u0001\u0007\u0001B\u0001B\u0003%!\u0006\u0003\u00052\u0001\t\u0005\t\u0015!\u0003+\u0011!\u0011\u0004A!A!\u0002\u0013\u0019\u0004\"\u0002\u001c\u0001\t\u00039\u0004\"B\u001f\u0001\t\u0013q\u0004\"\u0002\"\u0001\t\u0003J\u0003\"B\"\u0001\t\u0003J\u0003B\u0002#\u0001\t\u0003*R\tC\u0003P\u0001\u0011\u0005\u0003\u000bC\u0003_\u0001\u0011\u0005slB\u0003d+!\u0005AMB\u0003\u0015+!\u0005Q\rC\u00037\u001d\u0011\u0005\u0011\u000eC\u0004k\u001d\t\u0007I\u0011B6\t\r1t\u0001\u0015!\u00034\u0011\u0015ig\u0002\"\u0001o\u0011\u0015\th\u0002\"\u0003s\u0005Q)f.\u001b4jK\u0012lU-\\8ss6\u000bg.Y4fe*\u0011acF\u0001\u0007[\u0016lwN]=\u000b\u0005aI\u0012!B:qCJ\\'B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001e\u001c\"\u0001\u0001\u0010\u0011\u0005}\u0001S\"A\u000b\n\u0005\u0005*\"!D'f[>\u0014\u00180T1oC\u001e,'/\u0001\u0003d_:47\u0001\u0001\t\u0003K\u0019j\u0011aF\u0005\u0003O]\u0011\u0011b\u00159be.\u001cuN\u001c4\u0002\u001b5\f\u0007\u0010S3ba6+Wn\u001c:z+\u0005Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#\u0001\u0002'p]\u001e\fa\"\\1y\u0011\u0016\f\u0007/T3n_JL\b%A\fp]\"+\u0017\r]*u_J\fw-\u001a*fO&|gnU5{K\u0006Aa.^7D_J,7\u000f\u0005\u0002,i%\u0011Q\u0007\f\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\bF\u00039siZD\b\u0005\u0002 \u0001!)!E\u0002a\u0001I!)\u0001F\u0002a\u0001U!)\u0011G\u0002a\u0001U!)!G\u0002a\u0001g\u0005\u0001\u0012m]:feRLeN^1sS\u0006tGo\u001d\u000b\u0002\u007fA\u00111\u0006Q\u0005\u0003\u00032\u0012A!\u00168ji\u00061R.\u0019=P]\"+\u0017\r]*u_J\fw-Z'f[>\u0014\u00180A\fnCb|eM\u001a%fCB\u001cFo\u001c:bO\u0016lU-\\8ss\u00061\u0012mY9vSJ,W\t_3dkRLwN\\'f[>\u0014\u0018\u0010\u0006\u0003+\r\"S\u0005\"B$\u000b\u0001\u0004Q\u0013\u0001\u00038v[\nKH/Z:\t\u000b%S\u0001\u0019\u0001\u0016\u0002\u001bQ\f7o[!ui\u0016l\u0007\u000f^%e\u0011\u0015Y%\u00021\u0001M\u0003)iW-\\8ss6{G-\u001a\t\u0003?5K!AT\u000b\u0003\u00155+Wn\u001c:z\u001b>$W-\u0001\u000bbGF,\u0018N]3Ti>\u0014\u0018mZ3NK6|'/\u001f\u000b\u0005#RcV\f\u0005\u0002,%&\u00111\u000b\f\u0002\b\u0005>|G.Z1o\u0011\u0015)6\u00021\u0001W\u0003\u001d\u0011Gn\\2l\u0013\u0012\u0004\"a\u0016.\u000e\u0003aS!!W\f\u0002\u000fM$xN]1hK&\u00111\f\u0017\u0002\b\u00052|7m[%e\u0011\u001595\u00021\u0001+\u0011\u0015Y5\u00021\u0001M\u0003M\t7-];je\u0016,fN]8mY6+Wn\u001c:z)\u0011\t\u0006-\u00192\t\u000bUc\u0001\u0019\u0001,\t\u000b\u001dc\u0001\u0019\u0001\u0016\t\u000b-c\u0001\u0019\u0001'\u0002)Us\u0017NZ5fI6+Wn\u001c:z\u001b\u0006t\u0017mZ3s!\tybb\u0005\u0002\u000fMB\u00111fZ\u0005\u0003Q2\u0012a!\u00118z%\u00164G#\u00013\u00029I+5+\u0012*W\u000b\u0012{6+W*U\u000b6{V*R'P%f{&)\u0017+F'V\t1'A\u000fS\u000bN+%KV#E?NK6\u000bV#N?6+Uj\u0014*Z?\nKF+R*!\u0003\u0015\t\u0007\u000f\u001d7z)\rAt\u000e\u001d\u0005\u0006EI\u0001\r\u0001\n\u0005\u0006eI\u0001\raM\u0001\rO\u0016$X*\u0019=NK6|'/\u001f\u000b\u0003UMDQAI\nA\u0002\u0011\u0002")
public class UnifiedMemoryManager
extends MemoryManager {
    private final long maxHeapMemory;
    private final long onHeapStorageRegionSize;

    public static UnifiedMemoryManager apply(SparkConf sparkConf, int n) {
        return UnifiedMemoryManager$.MODULE$.apply(sparkConf, n);
    }

    public long maxHeapMemory() {
        return this.maxHeapMemory;
    }

    private void assertInvariants() {
        Predef$.MODULE$.assert(this.onHeapExecutionMemoryPool().poolSize() + this.onHeapStorageMemoryPool().poolSize() == this.maxHeapMemory());
        Predef$.MODULE$.assert(this.offHeapExecutionMemoryPool().poolSize() + this.offHeapStorageMemoryPool().poolSize() == this.maxOffHeapMemory());
    }

    @Override
    public synchronized long maxOnHeapStorageMemory() {
        return this.maxHeapMemory() - this.onHeapExecutionMemoryPool().memoryUsed();
    }

    @Override
    public synchronized long maxOffHeapStorageMemory() {
        return this.maxOffHeapMemory() - this.offHeapExecutionMemoryPool().memoryUsed();
    }

    @Override
    public synchronized long acquireExecutionMemory(long numBytes, long taskAttemptId, MemoryMode memoryMode) {
        Tuple4 tuple4;
        this.assertInvariants();
        Predef$.MODULE$.assert(numBytes >= 0L);
        MemoryMode memoryMode2 = memoryMode;
        if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) {
            tuple4 = new Tuple4((Object)this.onHeapExecutionMemoryPool(), (Object)this.onHeapStorageMemoryPool(), (Object)BoxesRunTime.boxToLong((long)this.onHeapStorageRegionSize), (Object)BoxesRunTime.boxToLong((long)this.maxHeapMemory()));
        } else if (((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) {
            tuple4 = new Tuple4((Object)this.offHeapExecutionMemoryPool(), (Object)this.offHeapStorageMemoryPool(), (Object)BoxesRunTime.boxToLong((long)this.offHeapStorageMemory()), (Object)BoxesRunTime.boxToLong((long)this.maxOffHeapMemory()));
        } else {
            throw new MatchError((Object)memoryMode2);
        }
        Tuple4 tuple42 = tuple4;
        if (tuple42 == null) {
            throw new MatchError((Object)tuple42);
        }
        ExecutionMemoryPool executionPool = (ExecutionMemoryPool)tuple42._1();
        StorageMemoryPool storagePool = (StorageMemoryPool)tuple42._2();
        long storageRegionSize = BoxesRunTime.unboxToLong((Object)tuple42._3());
        long maxMemory = BoxesRunTime.unboxToLong((Object)tuple42._4());
        Tuple4 tuple43 = new Tuple4((Object)executionPool, (Object)storagePool, (Object)BoxesRunTime.boxToLong((long)storageRegionSize), (Object)BoxesRunTime.boxToLong((long)maxMemory));
        ExecutionMemoryPool executionPool2 = (ExecutionMemoryPool)tuple43._1();
        StorageMemoryPool storagePool2 = (StorageMemoryPool)tuple43._2();
        long storageRegionSize2 = BoxesRunTime.unboxToLong((Object)tuple43._3());
        long maxMemory2 = BoxesRunTime.unboxToLong((Object)tuple43._4());
        return executionPool2.acquireMemory(numBytes, taskAttemptId, (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)extraMemoryNeeded -> UnifiedMemoryManager.maybeGrowExecutionPool$1(extraMemoryNeeded, storagePool2, storageRegionSize2, executionPool2), (Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> UnifiedMemoryManager.computeMaxExecutionPoolSize$1(maxMemory2, storagePool2, storageRegionSize2));
    }

    @Override
    public synchronized boolean acquireStorageMemory(BlockId blockId, long numBytes, MemoryMode memoryMode) {
        StorageMemoryPool storagePool;
        block6: {
            Tuple3 tuple3;
            this.assertInvariants();
            Predef$.MODULE$.assert(numBytes >= 0L);
            MemoryMode memoryMode2 = memoryMode;
            if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) {
                tuple3 = new Tuple3((Object)this.onHeapExecutionMemoryPool(), (Object)this.onHeapStorageMemoryPool(), (Object)BoxesRunTime.boxToLong((long)this.maxOnHeapStorageMemory()));
            } else if (((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) {
                tuple3 = new Tuple3((Object)this.offHeapExecutionMemoryPool(), (Object)this.offHeapStorageMemoryPool(), (Object)BoxesRunTime.boxToLong((long)this.maxOffHeapStorageMemory()));
            } else {
                throw new MatchError((Object)memoryMode2);
            }
            Tuple3 tuple32 = tuple3;
            if (tuple32 == null) {
                throw new MatchError((Object)tuple32);
            }
            ExecutionMemoryPool executionPool = (ExecutionMemoryPool)tuple32._1();
            StorageMemoryPool storagePool2 = (StorageMemoryPool)tuple32._2();
            long maxMemory = BoxesRunTime.unboxToLong((Object)tuple32._3());
            Tuple3 tuple33 = new Tuple3((Object)executionPool, (Object)storagePool2, (Object)BoxesRunTime.boxToLong((long)maxMemory));
            ExecutionMemoryPool executionPool2 = (ExecutionMemoryPool)tuple33._1();
            storagePool = (StorageMemoryPool)tuple33._2();
            long maxMemory2 = BoxesRunTime.unboxToLong((Object)tuple33._3());
            if (numBytes > maxMemory2) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(80).append("Will not store ").append(blockId).append(" as the required space (").append(numBytes).append(" bytes) exceeds our ").append("memory limit (").append(maxMemory2).append(" bytes)").toString());
                return false;
            }
            if (numBytes <= storagePool.memoryFree()) break block6;
            long memoryBorrowedFromExecution = Math.min(executionPool2.memoryFree(), numBytes - storagePool.memoryFree());
            executionPool2.decrementPoolSize(memoryBorrowedFromExecution);
            storagePool.incrementPoolSize(memoryBorrowedFromExecution);
        }
        return storagePool.acquireMemory(blockId, numBytes);
    }

    @Override
    public synchronized boolean acquireUnrollMemory(BlockId blockId, long numBytes, MemoryMode memoryMode) {
        return this.acquireStorageMemory(blockId, numBytes, memoryMode);
    }

    private static final void maybeGrowExecutionPool$1(long extraMemoryNeeded, StorageMemoryPool storagePool$1, long storageRegionSize$1, ExecutionMemoryPool executionPool$1) {
        if (extraMemoryNeeded > 0L) {
            long memoryReclaimableFromStorage = package$.MODULE$.max(storagePool$1.memoryFree(), storagePool$1.poolSize() - storageRegionSize$1);
            if (memoryReclaimableFromStorage > 0L) {
                long spaceToReclaim = storagePool$1.freeSpaceToShrinkPool(package$.MODULE$.min(extraMemoryNeeded, memoryReclaimableFromStorage));
                storagePool$1.decrementPoolSize(spaceToReclaim);
                executionPool$1.incrementPoolSize(spaceToReclaim);
                return;
            }
            return;
        }
    }

    private static final long computeMaxExecutionPoolSize$1(long maxMemory$1, StorageMemoryPool storagePool$1, long storageRegionSize$1) {
        return maxMemory$1 - package$.MODULE$.min(storagePool$1.memoryUsed(), storageRegionSize$1);
    }

    public UnifiedMemoryManager(SparkConf conf, long maxHeapMemory, long onHeapStorageRegionSize, int numCores) {
        this.maxHeapMemory = maxHeapMemory;
        this.onHeapStorageRegionSize = onHeapStorageRegionSize;
        super(conf, numCores, onHeapStorageRegionSize, maxHeapMemory - onHeapStorageRegionSize);
        this.assertInvariants();
    }
}

