/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.client.TestAdminBase;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
public class TestAdmin3
extends TestAdminBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAdmin3.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestAdmin3.class);

    @Test
    public void testDisableAndEnableTable() throws IOException {
        byte[] row = Bytes.toBytes((String)"row");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        byte[] value = Bytes.toBytes((String)"value");
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(table, HConstants.CATALOG_FAMILY);
        Put put = new Put(row);
        put.addColumn(HConstants.CATALOG_FAMILY, qualifier, value);
        ht.put(put);
        Get get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        ht.get(get);
        ADMIN.disableTable(ht.getName());
        Assert.assertTrue((String)"Table must be disabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getTableStateManager().isTableState(ht.getName(), new TableState.State[]{TableState.State.DISABLED}));
        Assert.assertEquals((Object)TableState.State.DISABLED, (Object)this.getStateFromMeta(table));
        get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        boolean ok = false;
        try {
            ht.get(get);
        }
        catch (TableNotEnabledException e) {
            ok = true;
        }
        ok = false;
        Scan scan = new Scan();
        try {
            ResultScanner scanner = ht.getScanner(scan);
            Result res = null;
            while ((res = scanner.next()) != null) {
            }
        }
        catch (TableNotEnabledException e) {
            ok = true;
        }
        Assert.assertTrue((boolean)ok);
        ADMIN.enableTable(table);
        Assert.assertTrue((String)"Table must be enabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getTableStateManager().isTableState(ht.getName(), new TableState.State[]{TableState.State.ENABLED}));
        Assert.assertEquals((Object)TableState.State.ENABLED, (Object)this.getStateFromMeta(table));
        try {
            ht.get(get);
        }
        catch (RetriesExhaustedException e) {
            ok = false;
        }
        Assert.assertTrue((boolean)ok);
        ht.close();
    }

    @Test
    public void testDisableAndEnableTables() throws IOException {
        TableName[] tableNames;
        byte[] row = Bytes.toBytes((String)"row");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        byte[] value = Bytes.toBytes((String)"value");
        TableName table1 = TableName.valueOf((String)(this.name.getMethodName() + "1"));
        TableName table2 = TableName.valueOf((String)(this.name.getMethodName() + "2"));
        Table ht1 = TEST_UTIL.createTable(table1, HConstants.CATALOG_FAMILY);
        Table ht2 = TEST_UTIL.createTable(table2, HConstants.CATALOG_FAMILY);
        Put put = new Put(row);
        put.addColumn(HConstants.CATALOG_FAMILY, qualifier, value);
        ht1.put(put);
        ht2.put(put);
        Get get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        ht1.get(get);
        ht2.get(get);
        for (TableName tableName : tableNames = ADMIN.listTableNames(Pattern.compile("testDisableAndEnableTable.*"))) {
            ADMIN.disableTable(tableName);
        }
        get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        boolean ok = false;
        try {
            ht1.get(get);
            ht2.get(get);
        }
        catch (DoNotRetryIOException e) {
            ok = true;
        }
        Assert.assertEquals((Object)TableState.State.DISABLED, (Object)this.getStateFromMeta(table1));
        Assert.assertEquals((Object)TableState.State.DISABLED, (Object)this.getStateFromMeta(table2));
        Assert.assertTrue((boolean)ok);
        for (TableName tableName : tableNames) {
            ADMIN.enableTable(tableName);
        }
        try {
            ht1.get(get);
        }
        catch (IOException e) {
            ok = false;
        }
        try {
            ht2.get(get);
        }
        catch (IOException e) {
            ok = false;
        }
        Assert.assertTrue((boolean)ok);
        ht1.close();
        ht2.close();
        Assert.assertEquals((Object)TableState.State.ENABLED, (Object)this.getStateFromMeta(table1));
        Assert.assertEquals((Object)TableState.State.ENABLED, (Object)this.getStateFromMeta(table2));
    }

    @Test
    public void testEnableTableRetainAssignment() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {4, 4, 4}, {5, 5, 5}, {6, 6, 6}, {7, 7, 7}, {8, 8, 8}, {9, 9, 9}};
        int expectedRegions = splitKeys.length + 1;
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HConstants.CATALOG_FAMILY)).build();
        ADMIN.createTable(desc, (byte[][])splitKeys);
        try (RegionLocator l = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            List regions = l.getAllRegionLocations();
            Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
            ADMIN.disableTable(tableName);
            ADMIN.enableTable(tableName);
            List regions2 = l.getAllRegionLocations();
            Assert.assertEquals((long)regions.size(), (long)regions2.size());
            Assert.assertTrue((boolean)regions2.containsAll(regions));
        }
    }

    @Test
    public void testEnableDisableAddColumnDeleteColumn() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        while (!ADMIN.isTableEnabled(TableName.valueOf((String)this.name.getMethodName()))) {
            Thread.sleep(10L);
        }
        ADMIN.disableTable(tableName);
        try {
            TEST_UTIL.getConnection().getTable(tableName);
        }
        catch (DoNotRetryIOException doNotRetryIOException) {
            // empty catch block
        }
        ADMIN.addColumnFamily(tableName, ColumnFamilyDescriptorBuilder.of((String)"col2"));
        ADMIN.enableTable(tableName);
        try {
            ADMIN.deleteColumnFamily(tableName, Bytes.toBytes((String)"col2"));
        }
        catch (TableNotDisabledException e) {
            LOG.info(e.toString(), (Throwable)e);
        }
        ADMIN.disableTable(tableName);
        ADMIN.deleteTable(tableName);
    }

    @Test
    public void testGetTableDescriptor() throws IOException {
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"fam1")).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"fam2")).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"fam3")).build();
        ADMIN.createTable(htd);
        Table table = TEST_UTIL.getConnection().getTable(htd.getTableName());
        TableDescriptor confirmedHtd = table.getDescriptor();
        Assert.assertEquals((long)0L, (long)TableDescriptor.COMPARATOR.compare(htd, confirmedHtd));
        MetaTableAccessor.fullScanMetaAndPrint((Connection)TEST_UTIL.getConnection());
        table.close();
    }

    @Test
    public void testReadOnlyTableModify() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableDescriptor)ADMIN.getDescriptor(tableName)).setReadOnly(true).build();
        ADMIN.modifyTable(htd);
        htd = TableDescriptorBuilder.newBuilder((TableDescriptor)ADMIN.getDescriptor(tableName)).setCompactionEnabled(false).build();
        ADMIN.modifyTable(htd);
        ADMIN.disableTable(tableName);
        ADMIN.deleteTable(tableName);
        Assert.assertFalse((boolean)ADMIN.tableExists(tableName));
    }

    @Test
    public void testDeleteLastColumnFamily() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        while (!ADMIN.isTableEnabled(TableName.valueOf((String)this.name.getMethodName()))) {
            Thread.sleep(10L);
        }
        try {
            ADMIN.deleteColumnFamily(tableName, HConstants.CATALOG_FAMILY);
            Assert.fail((String)"Should have failed to delete the only column family of a table");
        }
        catch (InvalidFamilyOperationException invalidFamilyOperationException) {
            // empty catch block
        }
        ADMIN.disableTable(tableName);
        try {
            ADMIN.deleteColumnFamily(tableName, HConstants.CATALOG_FAMILY);
            Assert.fail((String)"Should have failed to delete the only column family of a table");
        }
        catch (InvalidFamilyOperationException invalidFamilyOperationException) {
            // empty catch block
        }
        ADMIN.deleteTable(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteEditUnknownColumnFamilyAndOrTable() throws IOException {
        TableName nonexistentTable = TableName.valueOf((String)"nonexistent");
        byte[] nonexistentColumn = Bytes.toBytes((String)"nonexistent");
        ColumnFamilyDescriptor nonexistentHcd = ColumnFamilyDescriptorBuilder.of((byte[])nonexistentColumn);
        IOException exception = null;
        try {
            ADMIN.addColumnFamily(nonexistentTable, nonexistentHcd);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            ADMIN.deleteTable(nonexistentTable);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            ADMIN.deleteColumnFamily(nonexistentTable, nonexistentColumn);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            ADMIN.disableTable(nonexistentTable);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            ADMIN.enableTable(nonexistentTable);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            ADMIN.modifyColumnFamily(nonexistentTable, nonexistentHcd);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)nonexistentTable).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HConstants.CATALOG_FAMILY)).build();
            ADMIN.modifyTable(htd);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        TableName tableName = TableName.valueOf((String)(this.name.getMethodName() + System.currentTimeMillis()));
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"cf")).build();
        ADMIN.createTable(htd);
        try {
            exception = null;
            try {
                ADMIN.deleteColumnFamily(htd.getTableName(), nonexistentHcd.getName());
            }
            catch (IOException e) {
                exception = e;
            }
            Assert.assertTrue((String)("found=" + exception.getClass().getName()), (boolean)(exception instanceof InvalidFamilyOperationException));
            exception = null;
            try {
                ADMIN.modifyColumnFamily(htd.getTableName(), nonexistentHcd);
            }
            catch (IOException e) {
                exception = e;
            }
            Assert.assertTrue((String)("found=" + exception.getClass().getName()), (boolean)(exception instanceof InvalidFamilyOperationException));
        }
        finally {
            ADMIN.disableTable(tableName);
            ADMIN.deleteTable(tableName);
        }
    }
}

