/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.CombinedBlockCache;
import org.apache.hadoop.hbase.mob.MobFileCache;
import org.apache.hadoop.hbase.regionserver.HMobStore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWALSource;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hdfs.DFSHedgedReadMetrics;
import org.apache.hadoop.metrics2.MetricsExecutor;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class MetricsRegionServerWrapperImpl
implements MetricsRegionServerWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsRegionServerWrapperImpl.class);
    private final HRegionServer regionServer;
    private final MetricsWALSource metricsWALSource;
    private final ByteBuffAllocator allocator;
    private BlockCache blockCache;
    private BlockCache l1Cache = null;
    private BlockCache l2Cache = null;
    private MobFileCache mobFileCache;
    private CacheStats cacheStats;
    private CacheStats l1Stats = null;
    private CacheStats l2Stats = null;
    private volatile long numStores = 0L;
    private volatile long numWALFiles = 0L;
    private volatile long walFileSize = 0L;
    private volatile long numStoreFiles = 0L;
    private volatile long memstoreSize = 0L;
    private volatile long storeFileSize = 0L;
    private volatile long maxStoreFileCount = 0L;
    private volatile long maxStoreFileAge = 0L;
    private volatile long minStoreFileAge = 0L;
    private volatile long avgStoreFileAge = 0L;
    private volatile long numReferenceFiles = 0L;
    private volatile double requestsPerSecond = 0.0;
    private volatile long readRequestsCount = 0L;
    private volatile double readRequestsRatePerSecond = 0.0;
    private volatile long filteredReadRequestsCount = 0L;
    private volatile long writeRequestsCount = 0L;
    private volatile double writeRequestsRatePerSecond = 0.0;
    private volatile long checkAndMutateChecksFailed = 0L;
    private volatile long checkAndMutateChecksPassed = 0L;
    private volatile long storefileIndexSize = 0L;
    private volatile long totalStaticIndexSize = 0L;
    private volatile long totalStaticBloomSize = 0L;
    private volatile long numMutationsWithoutWAL = 0L;
    private volatile long dataInMemoryWithoutWAL = 0L;
    private volatile double percentFileLocal = 0.0;
    private volatile double percentFileLocalSecondaryRegions = 0.0;
    private volatile long flushedCellsCount = 0L;
    private volatile long compactedCellsCount = 0L;
    private volatile long majorCompactedCellsCount = 0L;
    private volatile long flushedCellsSize = 0L;
    private volatile long compactedCellsSize = 0L;
    private volatile long majorCompactedCellsSize = 0L;
    private volatile long cellsCountCompactedToMob = 0L;
    private volatile long cellsCountCompactedFromMob = 0L;
    private volatile long cellsSizeCompactedToMob = 0L;
    private volatile long cellsSizeCompactedFromMob = 0L;
    private volatile long mobFlushCount = 0L;
    private volatile long mobFlushedCellsCount = 0L;
    private volatile long mobFlushedCellsSize = 0L;
    private volatile long mobScanCellsCount = 0L;
    private volatile long mobScanCellsSize = 0L;
    private volatile long mobFileCacheAccessCount = 0L;
    private volatile long mobFileCacheMissCount = 0L;
    private volatile double mobFileCacheHitRatio = 0.0;
    private volatile long mobFileCacheEvictedCount = 0L;
    private volatile long mobFileCacheCount = 0L;
    private volatile long blockedRequestsCount = 0L;
    private volatile long averageRegionSize = 0L;
    protected final Map<String, ArrayList<Long>> requestsCountCache = new ConcurrentHashMap<String, ArrayList<Long>>();
    private ScheduledExecutorService executor;
    private Runnable runnable;
    private long period;
    private DFSHedgedReadMetrics dfsHedgedReadMetrics;

    public MetricsRegionServerWrapperImpl(HRegionServer regionServer) {
        this.regionServer = regionServer;
        this.initBlockCache();
        this.initMobFileCache();
        this.period = regionServer.getConfiguration().getLong("hbase.regionserver.metrics.period", 5000L);
        this.executor = CompatibilitySingletonFactory.getInstance(MetricsExecutor.class).getExecutor();
        this.runnable = new RegionServerMetricsWrapperRunnable();
        this.executor.scheduleWithFixedDelay(this.runnable, this.period, this.period, TimeUnit.MILLISECONDS);
        this.metricsWALSource = CompatibilitySingletonFactory.getInstance(MetricsWALSource.class);
        this.allocator = regionServer.getRpcServer().getByteBuffAllocator();
        try {
            this.dfsHedgedReadMetrics = FSUtils.getDFSHedgedReadMetrics(regionServer.getConfiguration());
        }
        catch (IOException e) {
            LOG.warn("Failed to get hedged metrics", (Throwable)e);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Computing regionserver metrics every " + this.period + " milliseconds");
        }
    }

    private void initBlockCache() {
        this.blockCache = this.regionServer.getBlockCache().orElse(null);
        CacheStats cacheStats = this.cacheStats = this.blockCache != null ? this.blockCache.getStats() : null;
        if (this.cacheStats != null) {
            if (this.cacheStats instanceof CombinedBlockCache.CombinedCacheStats) {
                this.l1Stats = ((CombinedBlockCache.CombinedCacheStats)this.cacheStats).getLruCacheStats();
                this.l2Stats = ((CombinedBlockCache.CombinedCacheStats)this.cacheStats).getBucketCacheStats();
            } else {
                this.l1Stats = this.cacheStats;
            }
        }
        if (this.blockCache != null) {
            if (this.blockCache instanceof CombinedBlockCache) {
                this.l1Cache = ((CombinedBlockCache)this.blockCache).getFirstLevelCache();
                this.l2Cache = ((CombinedBlockCache)this.blockCache).getSecondLevelCache();
            } else {
                this.l1Cache = this.blockCache;
            }
        }
    }

    private void initMobFileCache() {
        this.mobFileCache = this.regionServer.getMobFileCache().orElse(null);
    }

    @Override
    public String getClusterId() {
        return this.regionServer.getClusterId();
    }

    @Override
    public long getStartCode() {
        return this.regionServer.getStartcode();
    }

    @Override
    public String getZookeeperQuorum() {
        ZKWatcher zk = this.regionServer.getZooKeeper();
        if (zk == null) {
            return "";
        }
        return zk.getQuorum();
    }

    @Override
    public String getCoprocessors() {
        Object[] coprocessors = this.regionServer.getRegionServerCoprocessors();
        if (coprocessors == null || coprocessors.length == 0) {
            return "";
        }
        return StringUtils.join(coprocessors, ", ");
    }

    @Override
    public String getServerName() {
        ServerName serverName = this.regionServer.getServerName();
        if (serverName == null) {
            return "";
        }
        return serverName.getServerName();
    }

    @Override
    public long getNumOnlineRegions() {
        Collection<HRegion> onlineRegionsLocalContext = this.regionServer.getOnlineRegionsLocalContext();
        if (onlineRegionsLocalContext == null) {
            return 0L;
        }
        return onlineRegionsLocalContext.size();
    }

    @Override
    public long getTotalRequestCount() {
        return this.regionServer.rpcServices.requestCount.sum();
    }

    @Override
    public long getTotalRowActionRequestCount() {
        return this.readRequestsCount + this.writeRequestsCount;
    }

    @Override
    public int getSplitQueueSize() {
        if (this.regionServer.compactSplitThread == null) {
            return 0;
        }
        return this.regionServer.compactSplitThread.getSplitQueueSize();
    }

    @Override
    public int getCompactionQueueSize() {
        if (this.regionServer.compactSplitThread == null) {
            return 0;
        }
        return this.regionServer.compactSplitThread.getCompactionQueueSize();
    }

    @Override
    public int getSmallCompactionQueueSize() {
        if (this.regionServer.compactSplitThread == null) {
            return 0;
        }
        return this.regionServer.compactSplitThread.getSmallCompactionQueueSize();
    }

    @Override
    public int getLargeCompactionQueueSize() {
        if (this.regionServer.compactSplitThread == null) {
            return 0;
        }
        return this.regionServer.compactSplitThread.getLargeCompactionQueueSize();
    }

    @Override
    public int getFlushQueueSize() {
        if (this.regionServer.getMemStoreFlusher() == null) {
            return 0;
        }
        return this.regionServer.getMemStoreFlusher().getFlushQueueSize();
    }

    @Override
    public long getBlockCacheCount() {
        return this.blockCache != null ? this.blockCache.getBlockCount() : 0L;
    }

    @Override
    public long getBlockCacheDataBlockCount() {
        return this.blockCache != null ? this.blockCache.getDataBlockCount() : 0L;
    }

    @Override
    public long getMemStoreLimit() {
        return this.regionServer.getRegionServerAccounting().getGlobalMemStoreLimit();
    }

    @Override
    public long getBlockCacheSize() {
        return this.blockCache != null ? this.blockCache.getCurrentSize() : 0L;
    }

    @Override
    public long getBlockCacheFreeSize() {
        return this.blockCache != null ? this.blockCache.getFreeSize() : 0L;
    }

    @Override
    public long getBlockCacheHitCount() {
        return this.cacheStats != null ? this.cacheStats.getHitCount() : 0L;
    }

    @Override
    public long getBlockCachePrimaryHitCount() {
        return this.cacheStats != null ? this.cacheStats.getPrimaryHitCount() : 0L;
    }

    @Override
    public long getBlockCacheMissCount() {
        return this.cacheStats != null ? this.cacheStats.getMissCount() : 0L;
    }

    @Override
    public long getBlockCachePrimaryMissCount() {
        return this.cacheStats != null ? this.cacheStats.getPrimaryMissCount() : 0L;
    }

    @Override
    public long getBlockCacheEvictedCount() {
        return this.cacheStats != null ? this.cacheStats.getEvictedCount() : 0L;
    }

    @Override
    public long getBlockCachePrimaryEvictedCount() {
        return this.cacheStats != null ? this.cacheStats.getPrimaryEvictedCount() : 0L;
    }

    @Override
    public double getBlockCacheHitPercent() {
        double ratio;
        double d = ratio = this.cacheStats != null ? this.cacheStats.getHitRatio() : 0.0;
        if (Double.isNaN(ratio)) {
            ratio = 0.0;
        }
        return ratio * 100.0;
    }

    @Override
    public double getBlockCacheHitCachingPercent() {
        double ratio;
        double d = ratio = this.cacheStats != null ? this.cacheStats.getHitCachingRatio() : 0.0;
        if (Double.isNaN(ratio)) {
            ratio = 0.0;
        }
        return ratio * 100.0;
    }

    @Override
    public long getBlockCacheFailedInsertions() {
        return this.cacheStats != null ? this.cacheStats.getFailedInserts() : 0L;
    }

    @Override
    public long getL1CacheSize() {
        return this.l1Cache != null ? this.l1Cache.getCurrentSize() : 0L;
    }

    @Override
    public long getL1CacheFreeSize() {
        return this.l1Cache != null ? this.l1Cache.getFreeSize() : 0L;
    }

    @Override
    public long getL1CacheCount() {
        return this.l1Cache != null ? this.l1Cache.getBlockCount() : 0L;
    }

    @Override
    public long getL1CacheEvictedCount() {
        return this.l1Stats != null ? this.l1Stats.getEvictedCount() : 0L;
    }

    @Override
    public long getL2CacheSize() {
        return this.l2Cache != null ? this.l2Cache.getCurrentSize() : 0L;
    }

    @Override
    public long getL2CacheFreeSize() {
        return this.l2Cache != null ? this.l2Cache.getFreeSize() : 0L;
    }

    @Override
    public long getL2CacheCount() {
        return this.l2Cache != null ? this.l2Cache.getBlockCount() : 0L;
    }

    @Override
    public long getL2CacheEvictedCount() {
        return this.l2Stats != null ? this.l2Stats.getEvictedCount() : 0L;
    }

    @Override
    public long getL1CacheHitCount() {
        return this.l1Stats != null ? this.l1Stats.getHitCount() : 0L;
    }

    @Override
    public long getL1CacheMissCount() {
        return this.l1Stats != null ? this.l1Stats.getMissCount() : 0L;
    }

    @Override
    public double getL1CacheHitRatio() {
        return this.l1Stats != null ? this.l1Stats.getHitRatio() : 0.0;
    }

    @Override
    public double getL1CacheMissRatio() {
        return this.l1Stats != null ? this.l1Stats.getMissRatio() : 0.0;
    }

    @Override
    public long getL2CacheHitCount() {
        return this.l2Stats != null ? this.l2Stats.getHitCount() : 0L;
    }

    @Override
    public long getL2CacheMissCount() {
        return this.l2Stats != null ? this.l2Stats.getMissCount() : 0L;
    }

    @Override
    public double getL2CacheHitRatio() {
        return this.l2Stats != null ? this.l2Stats.getHitRatio() : 0.0;
    }

    @Override
    public double getL2CacheMissRatio() {
        return this.l2Stats != null ? this.l2Stats.getMissRatio() : 0.0;
    }

    @Override
    public void forceRecompute() {
        this.runnable.run();
    }

    @Override
    public long getNumStores() {
        return this.numStores;
    }

    @Override
    public long getNumWALFiles() {
        return this.numWALFiles;
    }

    @Override
    public long getWALFileSize() {
        return this.walFileSize;
    }

    @Override
    public long getNumWALSlowAppend() {
        return this.metricsWALSource.getSlowAppendCount();
    }

    @Override
    public long getNumStoreFiles() {
        return this.numStoreFiles;
    }

    @Override
    public long getMaxStoreFiles() {
        return this.maxStoreFileCount;
    }

    @Override
    public long getMaxStoreFileAge() {
        return this.maxStoreFileAge;
    }

    @Override
    public long getMinStoreFileAge() {
        return this.minStoreFileAge;
    }

    @Override
    public long getAvgStoreFileAge() {
        return this.avgStoreFileAge;
    }

    @Override
    public long getNumReferenceFiles() {
        return this.numReferenceFiles;
    }

    @Override
    public long getMemStoreSize() {
        return this.memstoreSize;
    }

    @Override
    public long getStoreFileSize() {
        return this.storeFileSize;
    }

    @Override
    public double getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    @Override
    public long getReadRequestsCount() {
        return this.readRequestsCount;
    }

    @Override
    public double getReadRequestsRatePerSecond() {
        return this.readRequestsRatePerSecond;
    }

    @Override
    public long getFilteredReadRequestsCount() {
        return this.filteredReadRequestsCount;
    }

    @Override
    public long getWriteRequestsCount() {
        return this.writeRequestsCount;
    }

    @Override
    public double getWriteRequestsRatePerSecond() {
        return this.writeRequestsRatePerSecond;
    }

    @Override
    public long getRpcGetRequestsCount() {
        return this.regionServer.rpcServices.rpcGetRequestCount.sum();
    }

    @Override
    public long getRpcScanRequestsCount() {
        return this.regionServer.rpcServices.rpcScanRequestCount.sum();
    }

    @Override
    public long getRpcFullScanRequestsCount() {
        return this.regionServer.rpcServices.rpcFullScanRequestCount.sum();
    }

    @Override
    public long getRpcMultiRequestsCount() {
        return this.regionServer.rpcServices.rpcMultiRequestCount.sum();
    }

    @Override
    public long getRpcMutateRequestsCount() {
        return this.regionServer.rpcServices.rpcMutateRequestCount.sum();
    }

    @Override
    public long getCheckAndMutateChecksFailed() {
        return this.checkAndMutateChecksFailed;
    }

    @Override
    public long getCheckAndMutateChecksPassed() {
        return this.checkAndMutateChecksPassed;
    }

    @Override
    public long getStoreFileIndexSize() {
        return this.storefileIndexSize;
    }

    @Override
    public long getTotalStaticIndexSize() {
        return this.totalStaticIndexSize;
    }

    @Override
    public long getTotalStaticBloomSize() {
        return this.totalStaticBloomSize;
    }

    @Override
    public long getNumMutationsWithoutWAL() {
        return this.numMutationsWithoutWAL;
    }

    @Override
    public long getDataInMemoryWithoutWAL() {
        return this.dataInMemoryWithoutWAL;
    }

    @Override
    public double getPercentFileLocal() {
        return this.percentFileLocal;
    }

    @Override
    public double getPercentFileLocalSecondaryRegions() {
        return this.percentFileLocalSecondaryRegions;
    }

    @Override
    public long getUpdatesBlockedTime() {
        if (this.regionServer.getMemStoreFlusher() == null) {
            return 0L;
        }
        return this.regionServer.getMemStoreFlusher().getUpdatesBlockedMsHighWater().sum();
    }

    @Override
    public long getFlushedCellsCount() {
        return this.flushedCellsCount;
    }

    @Override
    public long getCompactedCellsCount() {
        return this.compactedCellsCount;
    }

    @Override
    public long getMajorCompactedCellsCount() {
        return this.majorCompactedCellsCount;
    }

    @Override
    public long getFlushedCellsSize() {
        return this.flushedCellsSize;
    }

    @Override
    public long getCompactedCellsSize() {
        return this.compactedCellsSize;
    }

    @Override
    public long getMajorCompactedCellsSize() {
        return this.majorCompactedCellsSize;
    }

    @Override
    public long getCellsCountCompactedFromMob() {
        return this.cellsCountCompactedFromMob;
    }

    @Override
    public long getCellsCountCompactedToMob() {
        return this.cellsCountCompactedToMob;
    }

    @Override
    public long getCellsSizeCompactedFromMob() {
        return this.cellsSizeCompactedFromMob;
    }

    @Override
    public long getCellsSizeCompactedToMob() {
        return this.cellsSizeCompactedToMob;
    }

    @Override
    public long getMobFlushCount() {
        return this.mobFlushCount;
    }

    @Override
    public long getMobFlushedCellsCount() {
        return this.mobFlushedCellsCount;
    }

    @Override
    public long getMobFlushedCellsSize() {
        return this.mobFlushedCellsSize;
    }

    @Override
    public long getMobScanCellsCount() {
        return this.mobScanCellsCount;
    }

    @Override
    public long getMobScanCellsSize() {
        return this.mobScanCellsSize;
    }

    @Override
    public long getMobFileCacheAccessCount() {
        return this.mobFileCacheAccessCount;
    }

    @Override
    public long getMobFileCacheMissCount() {
        return this.mobFileCacheMissCount;
    }

    @Override
    public long getMobFileCacheCount() {
        return this.mobFileCacheCount;
    }

    @Override
    public long getMobFileCacheEvictedCount() {
        return this.mobFileCacheEvictedCount;
    }

    @Override
    public double getMobFileCacheHitPercent() {
        return this.mobFileCacheHitRatio * 100.0;
    }

    @Override
    public long getHedgedReadOps() {
        return this.dfsHedgedReadMetrics == null ? 0L : this.dfsHedgedReadMetrics.getHedgedReadOps();
    }

    @Override
    public long getHedgedReadWins() {
        return this.dfsHedgedReadMetrics == null ? 0L : this.dfsHedgedReadMetrics.getHedgedReadWins();
    }

    @Override
    public long getHedgedReadOpsInCurThread() {
        return this.dfsHedgedReadMetrics == null ? 0L : this.dfsHedgedReadMetrics.getHedgedReadOpsInCurThread();
    }

    @Override
    public long getTotalBytesRead() {
        return FSDataInputStreamWrapper.getTotalBytesRead();
    }

    @Override
    public long getLocalBytesRead() {
        return FSDataInputStreamWrapper.getLocalBytesRead();
    }

    @Override
    public long getShortCircuitBytesRead() {
        return FSDataInputStreamWrapper.getShortCircuitBytesRead();
    }

    @Override
    public long getZeroCopyBytesRead() {
        return FSDataInputStreamWrapper.getZeroCopyBytesRead();
    }

    @Override
    public long getBlockedRequestsCount() {
        return this.blockedRequestsCount;
    }

    @Override
    public long getAverageRegionSize() {
        return this.averageRegionSize;
    }

    @Override
    public long getDataMissCount() {
        return this.cacheStats != null ? this.cacheStats.getDataMissCount() : 0L;
    }

    @Override
    public long getLeafIndexMissCount() {
        return this.cacheStats != null ? this.cacheStats.getLeafIndexMissCount() : 0L;
    }

    @Override
    public long getBloomChunkMissCount() {
        return this.cacheStats != null ? this.cacheStats.getBloomChunkMissCount() : 0L;
    }

    @Override
    public long getMetaMissCount() {
        return this.cacheStats != null ? this.cacheStats.getMetaMissCount() : 0L;
    }

    @Override
    public long getRootIndexMissCount() {
        return this.cacheStats != null ? this.cacheStats.getRootIndexMissCount() : 0L;
    }

    @Override
    public long getIntermediateIndexMissCount() {
        return this.cacheStats != null ? this.cacheStats.getIntermediateIndexMissCount() : 0L;
    }

    @Override
    public long getFileInfoMissCount() {
        return this.cacheStats != null ? this.cacheStats.getFileInfoMissCount() : 0L;
    }

    @Override
    public long getGeneralBloomMetaMissCount() {
        return this.cacheStats != null ? this.cacheStats.getGeneralBloomMetaMissCount() : 0L;
    }

    @Override
    public long getDeleteFamilyBloomMissCount() {
        return this.cacheStats != null ? this.cacheStats.getDeleteFamilyBloomMissCount() : 0L;
    }

    @Override
    public long getTrailerMissCount() {
        return this.cacheStats != null ? this.cacheStats.getTrailerMissCount() : 0L;
    }

    @Override
    public long getDataHitCount() {
        return this.cacheStats != null ? this.cacheStats.getDataHitCount() : 0L;
    }

    @Override
    public long getLeafIndexHitCount() {
        return this.cacheStats != null ? this.cacheStats.getLeafIndexHitCount() : 0L;
    }

    @Override
    public long getBloomChunkHitCount() {
        return this.cacheStats != null ? this.cacheStats.getBloomChunkHitCount() : 0L;
    }

    @Override
    public long getMetaHitCount() {
        return this.cacheStats != null ? this.cacheStats.getMetaHitCount() : 0L;
    }

    @Override
    public long getRootIndexHitCount() {
        return this.cacheStats != null ? this.cacheStats.getRootIndexHitCount() : 0L;
    }

    @Override
    public long getIntermediateIndexHitCount() {
        return this.cacheStats != null ? this.cacheStats.getIntermediateIndexHitCount() : 0L;
    }

    @Override
    public long getFileInfoHitCount() {
        return this.cacheStats != null ? this.cacheStats.getFileInfoHitCount() : 0L;
    }

    @Override
    public long getGeneralBloomMetaHitCount() {
        return this.cacheStats != null ? this.cacheStats.getGeneralBloomMetaHitCount() : 0L;
    }

    @Override
    public long getDeleteFamilyBloomHitCount() {
        return this.cacheStats != null ? this.cacheStats.getDeleteFamilyBloomHitCount() : 0L;
    }

    @Override
    public long getTrailerHitCount() {
        return this.cacheStats != null ? this.cacheStats.getTrailerHitCount() : 0L;
    }

    @Override
    public long getByteBuffAllocatorHeapAllocationBytes() {
        return ByteBuffAllocator.getHeapAllocationBytes(this.allocator, ByteBuffAllocator.HEAP);
    }

    @Override
    public long getByteBuffAllocatorPoolAllocationBytes() {
        return this.allocator.getPoolAllocationBytes();
    }

    @Override
    public double getByteBuffAllocatorHeapAllocRatio() {
        return ByteBuffAllocator.getHeapAllocationRatio(this.allocator, ByteBuffAllocator.HEAP);
    }

    @Override
    public long getByteBuffAllocatorTotalBufferCount() {
        return this.allocator.getTotalBufferCount();
    }

    @Override
    public long getByteBuffAllocatorUsedBufferCount() {
        return this.allocator.getUsedBufferCount();
    }

    public class RegionServerMetricsWrapperRunnable
    implements Runnable {
        private long lastRan = 0L;

        @Override
        public synchronized void run() {
            try {
                HDFSBlocksDistribution hdfsBlocksDistribution = new HDFSBlocksDistribution();
                HDFSBlocksDistribution hdfsBlocksDistributionSecondaryRegions = new HDFSBlocksDistribution();
                long tempNumStores = 0L;
                long tempNumStoreFiles = 0L;
                long tempMemstoreSize = 0L;
                long tempStoreFileSize = 0L;
                long tempMaxStoreFileAge = 0L;
                long tempNumReferenceFiles = 0L;
                long tempMaxStoreFileCount = 0L;
                long avgAgeNumerator = 0L;
                long numHFiles = 0L;
                long tempMinStoreFileAge = Long.MAX_VALUE;
                long tempReadRequestsCount = 0L;
                long tempFilteredReadRequestsCount = 0L;
                long tempWriteRequestsCount = 0L;
                long tempCheckAndMutateChecksFailed = 0L;
                long tempCheckAndMutateChecksPassed = 0L;
                long tempStorefileIndexSize = 0L;
                long tempTotalStaticIndexSize = 0L;
                long tempTotalStaticBloomSize = 0L;
                long tempNumMutationsWithoutWAL = 0L;
                long tempDataInMemoryWithoutWAL = 0L;
                double tempPercentFileLocal = 0.0;
                double tempPercentFileLocalSecondaryRegions = 0.0;
                long tempFlushedCellsCount = 0L;
                long tempCompactedCellsCount = 0L;
                long tempMajorCompactedCellsCount = 0L;
                long tempFlushedCellsSize = 0L;
                long tempCompactedCellsSize = 0L;
                long tempMajorCompactedCellsSize = 0L;
                long tempCellsCountCompactedToMob = 0L;
                long tempCellsCountCompactedFromMob = 0L;
                long tempCellsSizeCompactedToMob = 0L;
                long tempCellsSizeCompactedFromMob = 0L;
                long tempMobFlushCount = 0L;
                long tempMobFlushedCellsCount = 0L;
                long tempMobFlushedCellsSize = 0L;
                long tempMobScanCellsCount = 0L;
                long tempMobScanCellsSize = 0L;
                long tempBlockedRequestsCount = 0L;
                int regionCount = 0;
                long currentReadRequestsCount = 0L;
                long currentWriteRequestsCount = 0L;
                long lastReadRequestsCount = 0L;
                long lastWriteRequestsCount = 0L;
                long readRequestsDelta = 0L;
                long writeRequestsDelta = 0L;
                long totalReadRequestsDelta = 0L;
                long totalWriteRequestsDelta = 0L;
                for (HRegion r : MetricsRegionServerWrapperImpl.this.regionServer.getOnlineRegionsLocalContext()) {
                    String encodedRegionName = r.getRegionInfo().getEncodedName();
                    currentReadRequestsCount = r.getReadRequestsCount();
                    currentWriteRequestsCount = r.getWriteRequestsCount();
                    if (MetricsRegionServerWrapperImpl.this.requestsCountCache.containsKey(encodedRegionName)) {
                        lastReadRequestsCount = MetricsRegionServerWrapperImpl.this.requestsCountCache.get(encodedRegionName).get(0);
                        lastWriteRequestsCount = MetricsRegionServerWrapperImpl.this.requestsCountCache.get(encodedRegionName).get(1);
                        readRequestsDelta = currentReadRequestsCount - lastReadRequestsCount;
                        writeRequestsDelta = currentWriteRequestsCount - lastWriteRequestsCount;
                        totalReadRequestsDelta += readRequestsDelta;
                        totalWriteRequestsDelta += writeRequestsDelta;
                        MetricsRegionServerWrapperImpl.this.requestsCountCache.get(encodedRegionName).set(0, currentReadRequestsCount);
                        MetricsRegionServerWrapperImpl.this.requestsCountCache.get(encodedRegionName).set(1, currentWriteRequestsCount);
                    } else {
                        ArrayList<Long> requests = new ArrayList<Long>(2);
                        requests.add(currentReadRequestsCount);
                        requests.add(currentWriteRequestsCount);
                        MetricsRegionServerWrapperImpl.this.requestsCountCache.put(encodedRegionName, requests);
                        totalReadRequestsDelta += currentReadRequestsCount;
                        totalWriteRequestsDelta += currentWriteRequestsCount;
                    }
                    tempNumMutationsWithoutWAL += r.getNumMutationsWithoutWAL();
                    tempDataInMemoryWithoutWAL += r.getDataInMemoryWithoutWAL();
                    tempReadRequestsCount += r.getReadRequestsCount();
                    tempFilteredReadRequestsCount += r.getFilteredReadRequestsCount();
                    tempWriteRequestsCount += r.getWriteRequestsCount();
                    tempCheckAndMutateChecksFailed += r.getCheckAndMutateChecksFailed();
                    tempCheckAndMutateChecksPassed += r.getCheckAndMutateChecksPassed();
                    tempBlockedRequestsCount += r.getBlockedRequestsCount();
                    List<HStore> storeList = r.getStores();
                    tempNumStores += (long)storeList.size();
                    for (Store store : storeList) {
                        OptionalLong storeMinStoreFileAge;
                        tempNumStoreFiles += (long)store.getStorefilesCount();
                        tempMemstoreSize += store.getMemStoreSize().getDataSize();
                        tempStoreFileSize += store.getStorefilesSize();
                        tempMaxStoreFileCount = Math.max(tempMaxStoreFileCount, (long)store.getStorefilesCount());
                        OptionalLong storeMaxStoreFileAge = store.getMaxStoreFileAge();
                        if (storeMaxStoreFileAge.isPresent() && storeMaxStoreFileAge.getAsLong() > tempMaxStoreFileAge) {
                            tempMaxStoreFileAge = storeMaxStoreFileAge.getAsLong();
                        }
                        if ((storeMinStoreFileAge = store.getMinStoreFileAge()).isPresent() && storeMinStoreFileAge.getAsLong() < tempMinStoreFileAge) {
                            tempMinStoreFileAge = storeMinStoreFileAge.getAsLong();
                        }
                        long storeHFiles = store.getNumHFiles();
                        numHFiles += storeHFiles;
                        tempNumReferenceFiles += store.getNumReferenceFiles();
                        OptionalDouble storeAvgStoreFileAge = store.getAvgStoreFileAge();
                        if (storeAvgStoreFileAge.isPresent()) {
                            avgAgeNumerator = (long)((double)avgAgeNumerator + storeAvgStoreFileAge.getAsDouble() * (double)storeHFiles);
                        }
                        tempStorefileIndexSize += store.getStorefilesRootLevelIndexSize();
                        tempTotalStaticBloomSize += store.getTotalStaticBloomSize();
                        tempTotalStaticIndexSize += store.getTotalStaticIndexSize();
                        tempFlushedCellsCount += store.getFlushedCellsCount();
                        tempCompactedCellsCount += store.getCompactedCellsCount();
                        tempMajorCompactedCellsCount += store.getMajorCompactedCellsCount();
                        tempFlushedCellsSize += store.getFlushedCellsSize();
                        tempCompactedCellsSize += store.getCompactedCellsSize();
                        tempMajorCompactedCellsSize += store.getMajorCompactedCellsSize();
                        if (!(store instanceof HMobStore)) continue;
                        HMobStore mobStore = (HMobStore)store;
                        tempCellsCountCompactedToMob += mobStore.getCellsCountCompactedToMob();
                        tempCellsCountCompactedFromMob += mobStore.getCellsCountCompactedFromMob();
                        tempCellsSizeCompactedToMob += mobStore.getCellsSizeCompactedToMob();
                        tempCellsSizeCompactedFromMob += mobStore.getCellsSizeCompactedFromMob();
                        tempMobFlushCount += mobStore.getMobFlushCount();
                        tempMobFlushedCellsCount += mobStore.getMobFlushedCellsCount();
                        tempMobFlushedCellsSize += mobStore.getMobFlushedCellsSize();
                        tempMobScanCellsCount += mobStore.getMobScanCellsCount();
                        tempMobScanCellsSize += mobStore.getMobScanCellsSize();
                    }
                    HDFSBlocksDistribution distro = r.getHDFSBlocksDistribution();
                    hdfsBlocksDistribution.add(distro);
                    if (r.getRegionInfo().getReplicaId() != 0) {
                        hdfsBlocksDistributionSecondaryRegions.add(distro);
                    }
                    ++regionCount;
                }
                float localityIndex = hdfsBlocksDistribution.getBlockLocalityIndex(MetricsRegionServerWrapperImpl.this.regionServer.getServerName().getHostname());
                tempPercentFileLocal = Double.isNaN(tempBlockedRequestsCount) ? 0.0 : (double)(localityIndex * 100.0f);
                float localityIndexSecondaryRegions = hdfsBlocksDistributionSecondaryRegions.getBlockLocalityIndex(MetricsRegionServerWrapperImpl.this.regionServer.getServerName().getHostname());
                tempPercentFileLocalSecondaryRegions = Double.isNaN(localityIndexSecondaryRegions) ? 0.0 : (double)(localityIndexSecondaryRegions * 100.0f);
                long currentTime = EnvironmentEdgeManager.currentTime();
                if (this.lastRan == 0L) {
                    this.lastRan = currentTime - MetricsRegionServerWrapperImpl.this.period;
                }
                if (currentTime - this.lastRan > 0L) {
                    MetricsRegionServerWrapperImpl.this.requestsPerSecond = (double)(totalReadRequestsDelta + totalWriteRequestsDelta) / ((double)(currentTime - this.lastRan) / 1000.0);
                    double d = (double)totalReadRequestsDelta / (double)MetricsRegionServerWrapperImpl.this.period;
                    double writeRequestsRatePerMilliSecond = (double)totalWriteRequestsDelta / (double)MetricsRegionServerWrapperImpl.this.period;
                    MetricsRegionServerWrapperImpl.this.readRequestsRatePerSecond = d * 1000.0;
                    MetricsRegionServerWrapperImpl.this.writeRequestsRatePerSecond = writeRequestsRatePerMilliSecond * 1000.0;
                }
                this.lastRan = currentTime;
                WALProvider wALProvider = MetricsRegionServerWrapperImpl.this.regionServer.getWalFactory().getWALProvider();
                WALProvider metaProvider = MetricsRegionServerWrapperImpl.this.regionServer.getWalFactory().getMetaWALProvider();
                MetricsRegionServerWrapperImpl.this.numWALFiles = (wALProvider == null ? 0L : wALProvider.getNumLogFiles()) + (metaProvider == null ? 0L : metaProvider.getNumLogFiles());
                MetricsRegionServerWrapperImpl.this.walFileSize = (wALProvider == null ? 0L : wALProvider.getLogFileSize()) + (metaProvider == null ? 0L : metaProvider.getLogFileSize());
                MetricsRegionServerWrapperImpl.this.numStores = tempNumStores;
                MetricsRegionServerWrapperImpl.this.numStoreFiles = tempNumStoreFiles;
                MetricsRegionServerWrapperImpl.this.memstoreSize = tempMemstoreSize;
                MetricsRegionServerWrapperImpl.this.storeFileSize = tempStoreFileSize;
                MetricsRegionServerWrapperImpl.this.maxStoreFileCount = tempMaxStoreFileCount;
                MetricsRegionServerWrapperImpl.this.maxStoreFileAge = tempMaxStoreFileAge;
                if (regionCount > 0) {
                    MetricsRegionServerWrapperImpl.this.averageRegionSize = (MetricsRegionServerWrapperImpl.this.memstoreSize + MetricsRegionServerWrapperImpl.this.storeFileSize) / (long)regionCount;
                }
                if (tempMinStoreFileAge != Long.MAX_VALUE) {
                    MetricsRegionServerWrapperImpl.this.minStoreFileAge = tempMinStoreFileAge;
                }
                if (numHFiles != 0L) {
                    MetricsRegionServerWrapperImpl.this.avgStoreFileAge = avgAgeNumerator / numHFiles;
                }
                MetricsRegionServerWrapperImpl.this.numReferenceFiles = tempNumReferenceFiles;
                MetricsRegionServerWrapperImpl.this.readRequestsCount = tempReadRequestsCount;
                MetricsRegionServerWrapperImpl.this.filteredReadRequestsCount = tempFilteredReadRequestsCount;
                MetricsRegionServerWrapperImpl.this.writeRequestsCount = tempWriteRequestsCount;
                MetricsRegionServerWrapperImpl.this.checkAndMutateChecksFailed = tempCheckAndMutateChecksFailed;
                MetricsRegionServerWrapperImpl.this.checkAndMutateChecksPassed = tempCheckAndMutateChecksPassed;
                MetricsRegionServerWrapperImpl.this.storefileIndexSize = tempStorefileIndexSize;
                MetricsRegionServerWrapperImpl.this.totalStaticIndexSize = tempTotalStaticIndexSize;
                MetricsRegionServerWrapperImpl.this.totalStaticBloomSize = tempTotalStaticBloomSize;
                MetricsRegionServerWrapperImpl.this.numMutationsWithoutWAL = tempNumMutationsWithoutWAL;
                MetricsRegionServerWrapperImpl.this.dataInMemoryWithoutWAL = tempDataInMemoryWithoutWAL;
                MetricsRegionServerWrapperImpl.this.percentFileLocal = tempPercentFileLocal;
                MetricsRegionServerWrapperImpl.this.percentFileLocalSecondaryRegions = tempPercentFileLocalSecondaryRegions;
                MetricsRegionServerWrapperImpl.this.flushedCellsCount = tempFlushedCellsCount;
                MetricsRegionServerWrapperImpl.this.compactedCellsCount = tempCompactedCellsCount;
                MetricsRegionServerWrapperImpl.this.majorCompactedCellsCount = tempMajorCompactedCellsCount;
                MetricsRegionServerWrapperImpl.this.flushedCellsSize = tempFlushedCellsSize;
                MetricsRegionServerWrapperImpl.this.compactedCellsSize = tempCompactedCellsSize;
                MetricsRegionServerWrapperImpl.this.majorCompactedCellsSize = tempMajorCompactedCellsSize;
                MetricsRegionServerWrapperImpl.this.cellsCountCompactedToMob = tempCellsCountCompactedToMob;
                MetricsRegionServerWrapperImpl.this.cellsCountCompactedFromMob = tempCellsCountCompactedFromMob;
                MetricsRegionServerWrapperImpl.this.cellsSizeCompactedToMob = tempCellsSizeCompactedToMob;
                MetricsRegionServerWrapperImpl.this.cellsSizeCompactedFromMob = tempCellsSizeCompactedFromMob;
                MetricsRegionServerWrapperImpl.this.mobFlushCount = tempMobFlushCount;
                MetricsRegionServerWrapperImpl.this.mobFlushedCellsCount = tempMobFlushedCellsCount;
                MetricsRegionServerWrapperImpl.this.mobFlushedCellsSize = tempMobFlushedCellsSize;
                MetricsRegionServerWrapperImpl.this.mobScanCellsCount = tempMobScanCellsCount;
                MetricsRegionServerWrapperImpl.this.mobScanCellsSize = tempMobScanCellsSize;
                MetricsRegionServerWrapperImpl.this.mobFileCacheAccessCount = MetricsRegionServerWrapperImpl.this.mobFileCache != null ? MetricsRegionServerWrapperImpl.this.mobFileCache.getAccessCount() : 0L;
                MetricsRegionServerWrapperImpl.this.mobFileCacheMissCount = MetricsRegionServerWrapperImpl.this.mobFileCache != null ? MetricsRegionServerWrapperImpl.this.mobFileCache.getMissCount() : 0L;
                MetricsRegionServerWrapperImpl.this.mobFileCacheHitRatio = MetricsRegionServerWrapperImpl.this.mobFileCache != null ? MetricsRegionServerWrapperImpl.this.mobFileCache.getHitRatio() : 0.0;
                if (Double.isNaN(MetricsRegionServerWrapperImpl.this.mobFileCacheHitRatio)) {
                    MetricsRegionServerWrapperImpl.this.mobFileCacheHitRatio = 0.0;
                }
                MetricsRegionServerWrapperImpl.this.mobFileCacheEvictedCount = MetricsRegionServerWrapperImpl.this.mobFileCache != null ? MetricsRegionServerWrapperImpl.this.mobFileCache.getEvictedFileCount() : 0L;
                MetricsRegionServerWrapperImpl.this.mobFileCacheCount = MetricsRegionServerWrapperImpl.this.mobFileCache != null ? (long)MetricsRegionServerWrapperImpl.this.mobFileCache.getCacheSize() : 0L;
                MetricsRegionServerWrapperImpl.this.blockedRequestsCount = tempBlockedRequestsCount;
            }
            catch (Throwable e) {
                LOG.warn("Caught exception! Will suppress and retry.", e);
            }
        }
    }
}

