/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.NavigableMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.replication.BulkLoadCellFilter;
import org.apache.hadoop.hbase.replication.WALCellFilter;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hbase.thirdparty.com.google.common.base.Predicate;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ScopeWALEntryFilter
implements WALEntryFilter,
WALCellFilter {
    private final BulkLoadCellFilter bulkLoadFilter = new BulkLoadCellFilter();

    @Override
    public WAL.Entry filter(WAL.Entry entry) {
        return entry;
    }

    private boolean hasGlobalScope(NavigableMap<byte[], Integer> scopes, byte[] family) {
        Integer scope = (Integer)scopes.get(family);
        return scope != null && scope == 1;
    }

    @Override
    public Cell filterCell(WAL.Entry entry, Cell cell) {
        final NavigableMap<byte[], Integer> scopes = entry.getKey().getReplicationScopes();
        if (scopes == null || scopes.isEmpty()) {
            return null;
        }
        byte[] family = CellUtil.cloneFamily(cell);
        if (CellUtil.matchingColumn(cell, WALEdit.METAFAMILY, WALEdit.BULK_LOAD)) {
            return this.bulkLoadFilter.filterCell(cell, new Predicate<byte[]>(){

                @Override
                public boolean apply(byte[] family) {
                    return !ScopeWALEntryFilter.this.hasGlobalScope(scopes, family);
                }
            });
        }
        return this.hasGlobalScope(scopes, family) ? cell : null;
    }
}

