/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.regionserver;

import java.io.IOException;
import java.io.Writer;
import java.lang.management.MemoryUsage;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.shaded.org.jamon.AbstractTemplateImpl;
import org.apache.hadoop.hbase.shaded.org.jamon.TemplateManager;
import org.apache.hadoop.hbase.shaded.org.jamon.emit.StandardEmitter;
import org.apache.hadoop.hbase.shaded.org.jamon.escaping.Escaping;
import org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl;
import org.apache.hadoop.hbase.util.DirectMemoryUtils;
import org.apache.hadoop.util.StringUtils;

public class ServerMetricsTmplImpl
extends AbstractTemplateImpl
implements ServerMetricsTmpl.Intf {
    private final MetricsRegionServerWrapper mWrap;
    private final MetricsHBaseServerWrapper mServerWrap;
    private final ByteBuffAllocator bbAllocator;

    protected static ServerMetricsTmpl.ImplData __jamon_setOptionalArguments(ServerMetricsTmpl.ImplData p_implData) {
        return p_implData;
    }

    public ServerMetricsTmplImpl(TemplateManager p_templateManager, ServerMetricsTmpl.ImplData p_implData) {
        super(p_templateManager, ServerMetricsTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.mWrap = p_implData.getMWrap();
        this.mServerWrap = p_implData.getMServerWrap();
        this.bbAllocator = p_implData.getBbAllocator();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n        <li class=\"\"><a href=\"#tab_memoryStats\" data-toggle=\"tab\">Memory</a></li>\n        <li class=\"\"><a href=\"#tab_requestStats\" data-toggle=\"tab\">Requests</a></li>\n        <li class=\"\"><a href=\"#tab_walStats\" data-toggle=\"tab\">WALs</a></li>\n        <li class=\"\"><a href=\"#tab_storeStats\" data-toggle=\"tab\">Storefiles</a></li>\n        <li class=\"\"><a href=\"#tab_queueStats\" data-toggle=\"tab\">Queues</a></li>\n        <li class=\"\"><a href=\"#tab_byteBuffAllocatorStats\" data-toggle=\"tab\">ByteBuffAllocator Stats</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_baseStats\">\n            ");
        this.__jamon_innerUnit__baseStats(jamonWriter, this.mWrap);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_memoryStats\">\n            ");
        this.__jamon_innerUnit__memoryStats(jamonWriter, this.mWrap);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_requestStats\">\n            ");
        this.__jamon_innerUnit__requestStats(jamonWriter, this.mWrap);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_walStats\">\n            ");
        this.__jamon_innerUnit__walStats(jamonWriter, this.mWrap);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_storeStats\">\n            ");
        this.__jamon_innerUnit__storeStats(jamonWriter, this.mWrap);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_queueStats\">\n            ");
        this.__jamon_innerUnit__queueStats(jamonWriter, this.mWrap, this.mServerWrap);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_byteBuffAllocatorStats\">\n            ");
        this.__jamon_innerUnit__byteBuffAllocatorStats(jamonWriter, this.bbAllocator);
        jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
    }

    private void __jamon_innerUnit__baseStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n    <tr>\n\n        <th>Requests Per Second</th>\n        <th>Num. Regions</th>\n        <th>Block locality</th>\n        <th>Block locality (Secondary replicas)</th>\n        <th>Slow WAL Append Count</th>\n    </tr>\n    <tr>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(String.format("%.0f", mWrap.getRequestsPerSecond())), jamonWriter);
        jamonWriter.write("</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mWrap.getNumOnlineRegions()), jamonWriter);
        jamonWriter.write("</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(String.format("%.3f", mWrap.getPercentFileLocal())), jamonWriter);
        Escaping.HTML.write(StandardEmitter.valueOf("%"), jamonWriter);
        jamonWriter.write("</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(String.format("%.3f", mWrap.getPercentFileLocalSecondaryRegions())), jamonWriter);
        Escaping.HTML.write(StandardEmitter.valueOf("%"), jamonWriter);
        jamonWriter.write("</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mWrap.getNumWALSlowAppend()), jamonWriter);
        jamonWriter.write("</td>\n    </tr>\n</table>\n");
    }

    private void __jamon_innerUnit__byteBuffAllocatorStats(Writer jamonWriter, ByteBuffAllocator bbAllocator) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>Total Heap Allocation</th>\n    <th>Total Pool Allocation</th>\n    <th>Heap Allocation Ratio</th>\n    <th>Total Buffer Count</th>\n    <th>Used Buffer Count</th>\n    <th>Buffer Size</th>\n</tr>\n<tr>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String((long)ByteBuffAllocator.getHeapAllocationBytes(bbAllocator, ByteBuffAllocator.HEAP), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String((long)bbAllocator.getPoolAllocationBytes(), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(String.format("%.3f", ByteBuffAllocator.getHeapAllocationRatio(bbAllocator, ByteBuffAllocator.HEAP) * 100.0)), jamonWriter);
        Escaping.HTML.write(StandardEmitter.valueOf("%"), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(bbAllocator.getTotalBufferCount()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(bbAllocator.getUsedBufferCount()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String((long)bbAllocator.getBufferSize(), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("</td>\n</tr>\n</table>\n");
    }

    private void __jamon_innerUnit__memoryStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap) throws IOException {
        long usedHeap = -1L;
        long maxHeap = -1L;
        MemoryUsage usage = MemorySizeUtil.safeGetHeapMemoryUsage();
        if (usage != null) {
            maxHeap = usage.getMax();
            usedHeap = usage.getUsed();
        }
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <tr>\n        <th>Used Heap</th>\n        <th>Max Heap</th>\n        <th>Direct Memory Used</th>\n        <th>Direct Memory Configured</th>\n        <th>Memstore Size</th>\n        <th>Memstore Limit</th>\n    </tr>\n</tr>\n<tr>\n    <td>\n        ");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String((long)usedHeap, (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("\n    </td>\n    <td>\n        ");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String((long)maxHeap, (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("\n    </td>\n    <td>\n        ");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String((long)DirectMemoryUtils.getDirectMemoryUsage(), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("\n    </td>\n    <td>\n        ");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String((long)DirectMemoryUtils.getDirectMemorySize(), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("\n    </td>\n    <td>\n        ");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String((long)mWrap.getMemStoreSize(), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("\n    </td>\n    <td>\n        ");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String((long)mWrap.getMemStoreLimit(), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("\n    </td>\n</tr>\n</table>\n");
    }

    private void __jamon_innerUnit__queueStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap, MetricsHBaseServerWrapper mServerWrap) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>Compaction Queue Length</th>\n    <th>Flush Queue Length</th>\n    <th>Priority Call Queue Length</th>\n    <th>General Call Queue Length</th>\n    <th>Replication Call Queue Length</th>\n    <th>Total Call Queue Size</th>\n\n</tr>\n<tr>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mWrap.getCompactionQueueSize()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mWrap.getFlushQueueSize()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mServerWrap.getPriorityQueueLength()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mServerWrap.getGeneralQueueLength()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mServerWrap.getReplicationQueueLength()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String((long)mServerWrap.getTotalQueueSize(), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("</td>\n</tr>\n</table>\n");
    }

    private void __jamon_innerUnit__requestStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>Request Per Second</th>\n    <th>Read Request Count</th>\n    <th>Filtered Read Request Count</th>\n    <th>Write Request Count</th>\n</tr>\n<tr>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(String.format("%.0f", mWrap.getRequestsPerSecond())), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mWrap.getReadRequestsCount()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mWrap.getFilteredReadRequestsCount()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mWrap.getWriteRequestsCount()), jamonWriter);
        jamonWriter.write("</td>\n</tr>\n</table>\n");
    }

    private void __jamon_innerUnit__storeStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n\n    <th>Num. Stores</th>\n    <th>Num. Storefiles</th>\n    <th>Root Index Size</th>\n    <th>Index Size</th>\n    <th>Bloom Size</th>\n</tr>\n<tr>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mWrap.getNumStores()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mWrap.getNumStoreFiles()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String((long)mWrap.getStoreFileIndexSize(), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String((long)mWrap.getTotalStaticIndexSize(), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String((long)mWrap.getTotalStaticBloomSize(), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("</td>\n</tr>\n</table>\n");
    }

    private void __jamon_innerUnit__walStats(Writer jamonWriter, MetricsRegionServerWrapper mWrap) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <tr>\n        <th>Num. WAL Files</th>\n        <th>Size. WAL Files</th>\n    </tr>\n</tr>\n<tr>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(mWrap.getNumWALFiles()), jamonWriter);
        jamonWriter.write("</td>\n    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(StringUtils.TraditionalBinaryPrefix.long2String((long)mWrap.getWALFileSize(), (String)"B", (int)1)), jamonWriter);
        jamonWriter.write("</td>\n</tr>\n</table>\n");
    }
}

