/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestStoragePolicyPermissionSettings {
    private static final short REPL = 1;
    private static final int SIZE = 128;
    private static Configuration conf;
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem fs;
    private static BlockStoragePolicySuite suite;
    private static BlockStoragePolicy cold;
    private static UserGroupInformation nonAdmin;
    private static UserGroupInformation admin;

    @BeforeClass
    public static void clusterSetUp() throws IOException {
        conf = new HdfsConfiguration();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        fs = cluster.getFileSystem();
        suite = BlockStoragePolicySuite.createDefaultSuite();
        cold = suite.getPolicy("COLD");
        nonAdmin = UserGroupInformation.createUserForTesting((String)"user1", (String[])new String[]{"test"});
        admin = UserGroupInformation.createUserForTesting((String)"user2", (String[])new String[]{"supergroup"});
    }

    @AfterClass
    public static void clusterShutdown() throws IOException {
        if (fs != null) {
            fs.close();
            fs = null;
        }
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    private void setFSNameSystemFinalField(String field, boolean value) throws NoSuchFieldException, IllegalAccessException {
        Field f = FSNamesystem.class.getDeclaredField(field);
        f.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(f, f.getModifiers() & 0xFFFFFFEF);
        f.set(cluster.getNamesystem(), value);
    }

    private void setStoragePolicyPermissions(boolean isStoragePolicyEnabled, boolean isStoragePolicySuperuserOnly) throws NoSuchFieldException, IllegalAccessException {
        this.setFSNameSystemFinalField("isStoragePolicyEnabled", isStoragePolicyEnabled);
        this.setFSNameSystemFinalField("isStoragePolicySuperuserOnly", isStoragePolicySuperuserOnly);
    }

    @Test
    public void testStoragePolicyPermissionDefault() throws Exception {
        Path foo = new Path("/foo");
        DFSTestUtil.createFile((FileSystem)fs, foo, 128L, (short)1, 0L);
        this.setStoragePolicyPermissions(true, false);
        FileSystem fileSystemNonAdmin = DFSTestUtil.getFileSystemAs(nonAdmin, conf);
        LambdaTestUtils.intercept(AccessControlException.class, (String)"Permission denied: user=user1", (String)"Only super user can set storage policy.", () -> fileSystemNonAdmin.setStoragePolicy(foo, cold.getName()));
        fs.setPermission(foo, new FsPermission("777"));
        Assert.assertNotEquals((Object)fs.getStoragePolicy(foo), (Object)cold);
        LambdaTestUtils.eval(() -> fileSystemNonAdmin.setStoragePolicy(foo, cold.getName()));
        Assert.assertEquals((Object)fs.getStoragePolicy(foo), (Object)cold);
    }

    @Test
    public void testStoragePolicyPermissionAdmins() throws Exception {
        Path foo = new Path("/foo");
        DFSTestUtil.createFile((FileSystem)fs, foo, 128L, (short)1, 0L);
        fs.setPermission(foo, new FsPermission("777"));
        this.setStoragePolicyPermissions(true, true);
        FileSystem fileSystemNonAdmin = DFSTestUtil.getFileSystemAs(nonAdmin, conf);
        LambdaTestUtils.intercept(AccessControlException.class, (String)"Access denied for user user1. Superuser privilege is required", (String)"Only super user can set storage policy.", () -> fileSystemNonAdmin.setStoragePolicy(foo, cold.getName()));
        FileSystem fileSystemAdmin = DFSTestUtil.getFileSystemAs(admin, conf);
        Assert.assertNotEquals((Object)fs.getStoragePolicy(foo), (Object)cold);
        LambdaTestUtils.eval(() -> fileSystemAdmin.setStoragePolicy(foo, cold.getName()));
        Assert.assertEquals((Object)fs.getStoragePolicy(foo), (Object)cold);
    }

    @Test
    public void testStoragePolicyPermissionDisabled() throws Exception {
        Path foo = new Path("/foo");
        DFSTestUtil.createFile((FileSystem)fs, foo, 128L, (short)1, 0L);
        fs.setPermission(foo, new FsPermission("777"));
        this.setStoragePolicyPermissions(false, false);
        FileSystem fileSystemAdmin = DFSTestUtil.getFileSystemAs(admin, conf);
        LambdaTestUtils.intercept(IOException.class, (String)"Failed to set storage policy since dfs.storage.policy.enabled is set to false.", (String)"Storage policy settings are disabled.", () -> fileSystemAdmin.setStoragePolicy(foo, cold.getName()));
        Assert.assertEquals((Object)suite.getDefaultPolicy(), (Object)fs.getStoragePolicy(foo));
    }
}

