/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.jute;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.hadoop.hbase.shaded.org.apache.jute.BinaryOutputArchive;
import org.apache.hadoop.hbase.shaded.org.apache.jute.CsvOutputArchive;
import org.apache.hadoop.hbase.shaded.org.apache.jute.OutputArchive;
import org.apache.hadoop.hbase.shaded.org.apache.jute.Record;
import org.apache.hadoop.hbase.shaded.org.apache.jute.XmlOutputArchive;

public class RecordWriter {
    private OutputArchive archive;
    private static HashMap<String, Method> archiveFactory = RecordWriter.constructFactory();

    static HashMap<String, Method> constructFactory() {
        HashMap<String, Method> factory = new HashMap<String, Method>();
        try {
            factory.put("binary", BinaryOutputArchive.class.getDeclaredMethod("getArchive", OutputStream.class));
            factory.put("csv", CsvOutputArchive.class.getDeclaredMethod("getArchive", OutputStream.class));
            factory.put("xml", XmlOutputArchive.class.getDeclaredMethod("getArchive", OutputStream.class));
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        return factory;
    }

    private static OutputArchive createArchive(OutputStream out, String format) throws IOException {
        Method factory = archiveFactory.get(format);
        if (factory != null) {
            Object[] params = new Object[]{out};
            try {
                return (OutputArchive)factory.invoke(null, params);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public RecordWriter(OutputStream out, String format) throws IOException {
        this.archive = RecordWriter.createArchive(out, format);
    }

    public void write(Record r) throws IOException {
        r.serialize(this.archive, "");
    }
}

