/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V2MetricValueStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ContainerResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.")
public class V2ContainerResourceMetricStatus {
    public static final String SERIALIZED_NAME_CONTAINER = "container";
    @SerializedName(value="container")
    private String container;
    public static final String SERIALIZED_NAME_CURRENT = "current";
    @SerializedName(value="current")
    private V2MetricValueStatus current;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;

    public V2ContainerResourceMetricStatus container(String container) {
        this.container = container;
        return this;
    }

    @ApiModelProperty(required=true, value="Container is the name of the container in the pods of the scaling target")
    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public V2ContainerResourceMetricStatus current(V2MetricValueStatus current) {
        this.current = current;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V2MetricValueStatus getCurrent() {
        return this.current;
    }

    public void setCurrent(V2MetricValueStatus current) {
        this.current = current;
    }

    public V2ContainerResourceMetricStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name is the name of the resource in question.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2ContainerResourceMetricStatus v2ContainerResourceMetricStatus = (V2ContainerResourceMetricStatus)o;
        return Objects.equals(this.container, v2ContainerResourceMetricStatus.container) && Objects.equals(this.current, v2ContainerResourceMetricStatus.current) && Objects.equals(this.name, v2ContainerResourceMetricStatus.name);
    }

    public int hashCode() {
        return Objects.hash(this.container, this.current, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2ContainerResourceMetricStatus {\n");
        sb.append("    container: ").append(this.toIndentedString(this.container)).append("\n");
        sb.append("    current: ").append(this.toIndentedString(this.current)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

