/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.net;

import org.apache.distributedlog.net.DNSResolver;

public class DNSResolverForRows
extends DNSResolver {
    static final String DEFAULT_ROW = "/default-region/default-row";

    public DNSResolverForRows() {
    }

    public DNSResolverForRows(String hostRegionOverrides) {
        super(hostRegionOverrides);
    }

    @Override
    protected String resolveToNetworkLocation(String domainName) {
        String rack;
        String[] parts = domainName.split("\\.");
        if (parts.length <= 0) {
            return DEFAULT_ROW;
        }
        String hostName = parts[0];
        String[] labels = hostName.split("-");
        if (labels.length != 4) {
            return DEFAULT_ROW;
        }
        String region = (String)this.hostNameToRegion.get(hostName);
        if (null == region) {
            region = labels[0];
        }
        if ((rack = labels[1]).length() < 2) {
            return String.format("/%s/%s", region, rack);
        }
        return String.format("/%s/%s", region, rack.substring(0, 2));
    }
}

