/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.credutils.kerberos;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public abstract class AbstractJaasConf
extends Configuration {
    private final String userPrincipalName;
    private final boolean enableDebugLogs;

    public AbstractJaasConf(String userPrincipalName, boolean enableDebugLogs) {
        this.userPrincipalName = userPrincipalName;
        this.enableDebugLogs = enableDebugLogs;
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("principal", this.userPrincipalName);
        options.put("isInitiator", Boolean.TRUE.toString());
        options.put("storeKey", Boolean.TRUE.toString());
        options.put("debug", Boolean.toString(this.enableDebugLogs));
        this.addOptions(options);
        return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, Collections.unmodifiableMap(options))};
    }

    abstract void addOptions(Map<String, String> var1);
}

