/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.servicebus.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.servicebus.NamespaceAuthorizationRule;
import com.microsoft.azure.management.servicebus.NamespaceSku;
import com.microsoft.azure.management.servicebus.Queue;
import com.microsoft.azure.management.servicebus.ServiceBusNamespace;
import com.microsoft.azure.management.servicebus.Sku;
import com.microsoft.azure.management.servicebus.Topic;
import com.microsoft.azure.management.servicebus.implementation.AuthorizationRuleBaseImpl;
import com.microsoft.azure.management.servicebus.implementation.NamespaceAuthorizationRulesImpl;
import com.microsoft.azure.management.servicebus.implementation.NamespaceInner;
import com.microsoft.azure.management.servicebus.implementation.QueuesImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManagementClientImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManager;
import com.microsoft.azure.management.servicebus.implementation.TopicsImpl;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import rx.Completable;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Func1;

@LangDefinition
class ServiceBusNamespaceImpl
extends GroupableResourceImpl<ServiceBusNamespace, NamespaceInner, ServiceBusNamespaceImpl, ServiceBusManager>
implements ServiceBusNamespace,
ServiceBusNamespace.Definition,
ServiceBusNamespace.Update {
    private List<Creatable<Queue>> queuesToCreate;
    private List<Creatable<Topic>> topicsToCreate;
    private List<Creatable<NamespaceAuthorizationRule>> rulesToCreate;
    private List<String> queuesToDelete;
    private List<String> topicsToDelete;
    private List<String> rulesToDelete;

    ServiceBusNamespaceImpl(String name, NamespaceInner inner, ServiceBusManager manager) {
        super(name, (Resource)inner, (ManagerBase)manager);
        this.initChildrenOperationsCache();
    }

    @Override
    public String dnsLabel() {
        return ((NamespaceInner)((Object)this.inner())).name();
    }

    @Override
    public String fqdn() {
        return ((NamespaceInner)((Object)this.inner())).serviceBusEndpoint();
    }

    @Override
    public NamespaceSku sku() {
        return new NamespaceSku(((NamespaceInner)((Object)this.inner())).sku());
    }

    @Override
    public DateTime createdAt() {
        return ((NamespaceInner)((Object)this.inner())).createdAt();
    }

    @Override
    public DateTime updatedAt() {
        return ((NamespaceInner)((Object)this.inner())).updatedAt();
    }

    @Override
    public QueuesImpl queues() {
        return new QueuesImpl(this.resourceGroupName(), this.name(), this.region(), (ServiceBusManager)this.manager());
    }

    @Override
    public TopicsImpl topics() {
        return new TopicsImpl(this.resourceGroupName(), this.name(), this.region(), (ServiceBusManager)this.manager());
    }

    @Override
    public NamespaceAuthorizationRulesImpl authorizationRules() {
        return new NamespaceAuthorizationRulesImpl(this.resourceGroupName(), this.name(), this.region(), (ServiceBusManager)this.manager());
    }

    @Override
    public ServiceBusNamespaceImpl withSku(NamespaceSku namespaceSku) {
        ((NamespaceInner)((Object)this.inner())).withSku(new Sku().withName(namespaceSku.name()).withTier(namespaceSku.tier()).withCapacity(namespaceSku.capacity()));
        return this;
    }

    @Override
    public ServiceBusNamespaceImpl withNewQueue(String name, int maxSizeInMB) {
        this.queuesToCreate.add(this.queues().define(name).withSizeInMB(maxSizeInMB));
        return this;
    }

    @Override
    public ServiceBusNamespaceImpl withoutQueue(String name) {
        this.queuesToDelete.add(name);
        return this;
    }

    @Override
    public ServiceBusNamespaceImpl withNewTopic(String name, int maxSizeInMB) {
        this.topicsToCreate.add(this.topics().define(name).withSizeInMB(maxSizeInMB));
        return this;
    }

    @Override
    public ServiceBusNamespaceImpl withoutTopic(String name) {
        this.topicsToDelete.add(name);
        return this;
    }

    @Override
    public ServiceBusNamespaceImpl withNewSendRule(String name) {
        this.rulesToCreate.add((Creatable<NamespaceAuthorizationRule>)((AuthorizationRuleBaseImpl)this.authorizationRules().define(name)).withSendingEnabled());
        return this;
    }

    @Override
    public ServiceBusNamespaceImpl withNewListenRule(String name) {
        this.rulesToCreate.add((Creatable<NamespaceAuthorizationRule>)((AuthorizationRuleBaseImpl)this.authorizationRules().define(name)).withListeningEnabled());
        return this;
    }

    @Override
    public ServiceBusNamespaceImpl withNewManageRule(String name) {
        this.rulesToCreate.add((Creatable<NamespaceAuthorizationRule>)((AuthorizationRuleBaseImpl)this.authorizationRules().define(name)).withManagementEnabled());
        return this;
    }

    @Override
    public ServiceBusNamespaceImpl withoutAuthorizationRule(String name) {
        this.rulesToDelete.add(name);
        return this;
    }

    protected Observable<NamespaceInner> getInnerAsync() {
        return ((ServiceBusManagementClientImpl)((Object)((ServiceBusManager)this.manager()).inner())).namespaces().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Observable<ServiceBusNamespace> createResourceAsync() {
        Completable createNamespaceCompletable = ((ServiceBusManagementClientImpl)((Object)((ServiceBusManager)this.manager()).inner())).namespaces().createOrUpdateAsync(this.resourceGroupName(), this.name(), (NamespaceInner)((Object)this.inner())).map((Func1)new Func1<NamespaceInner, NamespaceInner>(){

            public NamespaceInner call(NamespaceInner inner) {
                ServiceBusNamespaceImpl.this.setInner((Object)inner);
                return inner;
            }
        }).toCompletable();
        Completable childrenOperationsCompletable = this.submitChildrenOperationsAsync();
        ServiceBusNamespaceImpl self = this;
        return Completable.concat((Completable[])new Completable[]{createNamespaceCompletable, childrenOperationsCompletable}).doOnTerminate(new Action0(){

            public void call() {
                ServiceBusNamespaceImpl.this.initChildrenOperationsCache();
            }
        }).andThen(Observable.just((Object)self));
    }

    private void initChildrenOperationsCache() {
        this.queuesToCreate = new ArrayList<Creatable<Queue>>();
        this.topicsToCreate = new ArrayList<Creatable<Topic>>();
        this.rulesToCreate = new ArrayList<Creatable<NamespaceAuthorizationRule>>();
        this.queuesToDelete = new ArrayList<String>();
        this.topicsToDelete = new ArrayList<String>();
        this.rulesToDelete = new ArrayList<String>();
    }

    private Completable submitChildrenOperationsAsync() {
        Observable queuesCreateStream = Observable.empty();
        if (this.queuesToCreate.size() > 0) {
            queuesCreateStream = this.queues().createAsync(this.queuesToCreate);
        }
        Observable topicsCreateStream = Observable.empty();
        if (this.topicsToCreate.size() > 0) {
            topicsCreateStream = this.topics().createAsync(this.topicsToCreate);
        }
        Observable rulesCreateStream = Observable.empty();
        if (this.rulesToCreate.size() > 0) {
            rulesCreateStream = this.authorizationRules().createAsync(this.rulesToCreate);
        }
        Observable<String> queuesDeleteStream = Observable.empty();
        if (this.queuesToDelete.size() > 0) {
            queuesDeleteStream = this.queues().deleteByNameAsync(this.queuesToDelete);
        }
        Observable<String> topicsDeleteStream = Observable.empty();
        if (this.topicsToDelete.size() > 0) {
            topicsDeleteStream = this.topics().deleteByNameAsync(this.topicsToDelete);
        }
        Observable<String> rulesDeleteStream = Observable.empty();
        if (this.rulesToDelete.size() > 0) {
            rulesDeleteStream = this.authorizationRules().deleteByNameAsync(this.rulesToDelete);
        }
        return Completable.mergeDelayError((Completable[])new Completable[]{queuesCreateStream.toCompletable(), topicsCreateStream.toCompletable(), rulesCreateStream.toCompletable(), queuesDeleteStream.toCompletable(), topicsDeleteStream.toCompletable(), rulesDeleteStream.toCompletable()});
    }
}

