/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.servicebus.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.servicebus.Policykey;
import com.microsoft.azure.management.servicebus.TopicAuthorizationRule;
import com.microsoft.azure.management.servicebus.implementation.AuthorizationRuleBaseImpl;
import com.microsoft.azure.management.servicebus.implementation.ResourceListKeysInner;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManagementClientImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManager;
import com.microsoft.azure.management.servicebus.implementation.SharedAccessAuthorizationRuleInner;
import com.microsoft.azure.management.servicebus.implementation.TopicImpl;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class TopicAuthorizationRuleImpl
extends AuthorizationRuleBaseImpl<TopicAuthorizationRule, TopicImpl, SharedAccessAuthorizationRuleInner, TopicAuthorizationRuleImpl, ServiceBusManager>
implements TopicAuthorizationRule,
TopicAuthorizationRule.Definition,
TopicAuthorizationRule.Update {
    private final String namespaceName;
    private final Region region;

    TopicAuthorizationRuleImpl(String resourceGroupName, String namespaceName, String topicName, String name, Region region, SharedAccessAuthorizationRuleInner inner, ServiceBusManager manager) {
        super(name, inner, manager);
        this.namespaceName = namespaceName;
        this.region = region;
        this.withExistingParentResource(resourceGroupName, topicName);
        if (inner.location() == null) {
            inner.withLocation(this.region.toString());
        }
    }

    @Override
    public String namespaceName() {
        return this.namespaceName;
    }

    @Override
    public String topicName() {
        return this.parentName;
    }

    protected Observable<SharedAccessAuthorizationRuleInner> getInnerAsync() {
        return ((ServiceBusManagementClientImpl)((Object)((ServiceBusManager)((Object)this.manager())).inner())).topics().getAuthorizationRuleAsync(this.resourceGroupName(), this.namespaceName(), this.topicName(), this.name());
    }

    protected Observable<TopicAuthorizationRule> createChildResourceAsync() {
        final TopicAuthorizationRuleImpl self = this;
        return ((ServiceBusManagementClientImpl)((Object)((ServiceBusManager)((Object)this.manager())).inner())).topics().createOrUpdateAuthorizationRuleAsync(this.resourceGroupName(), this.namespaceName(), this.topicName(), this.name(), ((SharedAccessAuthorizationRuleInner)((Object)this.inner())).rights()).map((Func1)new Func1<SharedAccessAuthorizationRuleInner, TopicAuthorizationRule>(){

            public TopicAuthorizationRule call(SharedAccessAuthorizationRuleInner inner) {
                TopicAuthorizationRuleImpl.this.setInner((Object)inner);
                return self;
            }
        });
    }

    @Override
    protected Observable<ResourceListKeysInner> getKeysInnerAsync() {
        return ((ServiceBusManagementClientImpl)((Object)((ServiceBusManager)((Object)this.manager())).inner())).topics().listKeysAsync(this.resourceGroupName(), this.namespaceName(), this.topicName(), this.name());
    }

    @Override
    protected Observable<ResourceListKeysInner> regenerateKeysInnerAsync(Policykey policykey) {
        return ((ServiceBusManagementClientImpl)((Object)((ServiceBusManager)((Object)this.manager())).inner())).topics().regenerateKeysAsync(this.resourceGroupName(), this.namespaceName(), this.topicName(), this.name(), policykey);
    }
}

