/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.VirtualWANInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class VirtualWANsInner
implements InnerSupportsGet<VirtualWANInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<VirtualWANInner> {
    private VirtualWANsService service;
    private NetworkManagementClientImpl client;

    public VirtualWANsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (VirtualWANsService)retrofit.create(VirtualWANsService.class);
        this.client = client;
    }

    public VirtualWANInner getByResourceGroup(String resourceGroupName, String virtualWANName) {
        return (VirtualWANInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualWANName).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualWANInner> getByResourceGroupAsync(String resourceGroupName, String virtualWANName, ServiceCallback<VirtualWANInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualWANName), serviceCallback);
    }

    public Observable<VirtualWANInner> getByResourceGroupAsync(String resourceGroupName, String virtualWANName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualWANName).map((Func1)new Func1<ServiceResponse<VirtualWANInner>, VirtualWANInner>(){

            public VirtualWANInner call(ServiceResponse<VirtualWANInner> response) {
                return (VirtualWANInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualWANInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String virtualWANName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.getByResourceGroup(resourceGroupName, virtualWANName, this.client.subscriptionId(), "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualWANInner>>>(){

            public Observable<ServiceResponse<VirtualWANInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualWANsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualWANInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualWANInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public VirtualWANInner createOrUpdate(String resourceGroupName, String virtualWANName, VirtualWANInner wANParameters) {
        return (VirtualWANInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWANName, wANParameters).toBlocking().last()).body());
    }

    public ServiceFuture<VirtualWANInner> createOrUpdateAsync(String resourceGroupName, String virtualWANName, VirtualWANInner wANParameters, ServiceCallback<VirtualWANInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWANName, wANParameters), serviceCallback);
    }

    public Observable<VirtualWANInner> createOrUpdateAsync(String resourceGroupName, String virtualWANName, VirtualWANInner wANParameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWANName, wANParameters).map((Func1)new Func1<ServiceResponse<VirtualWANInner>, VirtualWANInner>(){

            public VirtualWANInner call(ServiceResponse<VirtualWANInner> response) {
                return (VirtualWANInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualWANInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualWANName, VirtualWANInner wANParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        if (wANParameters == null) {
            throw new IllegalArgumentException("Parameter wANParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)wANParameters));
        String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, virtualWANName, "2018-06-01", wANParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualWANInner>(){}.getType());
    }

    public VirtualWANInner beginCreateOrUpdate(String resourceGroupName, String virtualWANName, VirtualWANInner wANParameters) {
        return (VirtualWANInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWANName, wANParameters).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualWANInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualWANName, VirtualWANInner wANParameters, ServiceCallback<VirtualWANInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWANName, wANParameters), serviceCallback);
    }

    public Observable<VirtualWANInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualWANName, VirtualWANInner wANParameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWANName, wANParameters).map((Func1)new Func1<ServiceResponse<VirtualWANInner>, VirtualWANInner>(){

            public VirtualWANInner call(ServiceResponse<VirtualWANInner> response) {
                return (VirtualWANInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualWANInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualWANName, VirtualWANInner wANParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        if (wANParameters == null) {
            throw new IllegalArgumentException("Parameter wANParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)wANParameters));
        String apiVersion = "2018-06-01";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, virtualWANName, "2018-06-01", wANParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualWANInner>>>(){

            public Observable<ServiceResponse<VirtualWANInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualWANsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualWANInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualWANInner>(){}.getType()).register(201, new TypeToken<VirtualWANInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public VirtualWANInner updateTags(String resourceGroupName, String virtualWANName) {
        return (VirtualWANInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName).toBlocking().last()).body());
    }

    public ServiceFuture<VirtualWANInner> updateTagsAsync(String resourceGroupName, String virtualWANName, ServiceCallback<VirtualWANInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName), serviceCallback);
    }

    public Observable<VirtualWANInner> updateTagsAsync(String resourceGroupName, String virtualWANName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName).map((Func1)new Func1<ServiceResponse<VirtualWANInner>, VirtualWANInner>(){

            public VirtualWANInner call(ServiceResponse<VirtualWANInner> response) {
                return (VirtualWANInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualWANInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String virtualWANName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        Object tags = null;
        TagsObject wANParameters = new TagsObject();
        wANParameters.withTags(null);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(this.client.subscriptionId(), resourceGroupName, virtualWANName, "2018-06-01", this.client.acceptLanguage(), wANParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualWANInner>(){}.getType());
    }

    public VirtualWANInner updateTags(String resourceGroupName, String virtualWANName, Map<String, String> tags) {
        return (VirtualWANInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName, tags).toBlocking().last()).body());
    }

    public ServiceFuture<VirtualWANInner> updateTagsAsync(String resourceGroupName, String virtualWANName, Map<String, String> tags, ServiceCallback<VirtualWANInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName, tags), serviceCallback);
    }

    public Observable<VirtualWANInner> updateTagsAsync(String resourceGroupName, String virtualWANName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName, tags).map((Func1)new Func1<ServiceResponse<VirtualWANInner>, VirtualWANInner>(){

            public VirtualWANInner call(ServiceResponse<VirtualWANInner> response) {
                return (VirtualWANInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualWANInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String virtualWANName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2018-06-01";
        TagsObject wANParameters = new TagsObject();
        wANParameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(this.client.subscriptionId(), resourceGroupName, virtualWANName, "2018-06-01", this.client.acceptLanguage(), wANParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualWANInner>(){}.getType());
    }

    public VirtualWANInner beginUpdateTags(String resourceGroupName, String virtualWANName) {
        return (VirtualWANInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualWANInner> beginUpdateTagsAsync(String resourceGroupName, String virtualWANName, ServiceCallback<VirtualWANInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName), serviceCallback);
    }

    public Observable<VirtualWANInner> beginUpdateTagsAsync(String resourceGroupName, String virtualWANName) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName).map((Func1)new Func1<ServiceResponse<VirtualWANInner>, VirtualWANInner>(){

            public VirtualWANInner call(ServiceResponse<VirtualWANInner> response) {
                return (VirtualWANInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualWANInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String virtualWANName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        Object tags = null;
        TagsObject wANParameters = new TagsObject();
        wANParameters.withTags(null);
        return this.service.beginUpdateTags(this.client.subscriptionId(), resourceGroupName, virtualWANName, "2018-06-01", this.client.acceptLanguage(), wANParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualWANInner>>>(){

            public Observable<ServiceResponse<VirtualWANInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualWANsInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public VirtualWANInner beginUpdateTags(String resourceGroupName, String virtualWANName, Map<String, String> tags) {
        return (VirtualWANInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualWANInner> beginUpdateTagsAsync(String resourceGroupName, String virtualWANName, Map<String, String> tags, ServiceCallback<VirtualWANInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName, tags), serviceCallback);
    }

    public Observable<VirtualWANInner> beginUpdateTagsAsync(String resourceGroupName, String virtualWANName, Map<String, String> tags) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, virtualWANName, tags).map((Func1)new Func1<ServiceResponse<VirtualWANInner>, VirtualWANInner>(){

            public VirtualWANInner call(ServiceResponse<VirtualWANInner> response) {
                return (VirtualWANInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualWANInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String virtualWANName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2018-06-01";
        TagsObject wANParameters = new TagsObject();
        wANParameters.withTags(tags);
        return this.service.beginUpdateTags(this.client.subscriptionId(), resourceGroupName, virtualWANName, "2018-06-01", this.client.acceptLanguage(), wANParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualWANInner>>>(){

            public Observable<ServiceResponse<VirtualWANInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualWANsInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualWANInner> beginUpdateTagsDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualWANInner>(){}.getType()).register(201, new TypeToken<VirtualWANInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public void delete(String resourceGroupName, String virtualWANName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, virtualWANName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String virtualWANName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, virtualWANName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String virtualWANName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, virtualWANName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String virtualWANName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, virtualWANName, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String virtualWANName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualWANName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String virtualWANName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualWANName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String virtualWANName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualWANName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String virtualWANName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWANName == null) {
            throw new IllegalArgumentException("Parameter virtualWANName is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, virtualWANName, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualWANsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<VirtualWANInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<VirtualWANInner>((Page)response.body()){

            public Page<VirtualWANInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualWANsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualWANInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<VirtualWANInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualWANInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualWANInner>>> call(String nextPageLink) {
                return VirtualWANsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualWANInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<VirtualWANInner>>, Page<VirtualWANInner>>(){

            public Page<VirtualWANInner> call(ServiceResponse<Page<VirtualWANInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualWANInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualWANInner>>, Observable<ServiceResponse<Page<VirtualWANInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualWANInner>>> call(ServiceResponse<Page<VirtualWANInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualWANsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualWANInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualWANInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualWANInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualWANsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualWANInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualWANInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<VirtualWANInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<VirtualWANInner>((Page)response.body()){

            public Page<VirtualWANInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualWANsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualWANInner>> listAsync(ListOperationCallback<VirtualWANInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualWANInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualWANInner>>> call(String nextPageLink) {
                return VirtualWANsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualWANInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<VirtualWANInner>>, Page<VirtualWANInner>>(){

            public Page<VirtualWANInner> call(ServiceResponse<Page<VirtualWANInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualWANInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<VirtualWANInner>>, Observable<ServiceResponse<Page<VirtualWANInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualWANInner>>> call(ServiceResponse<Page<VirtualWANInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualWANsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualWANInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.list(this.client.subscriptionId(), "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualWANInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualWANInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualWANsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualWANInner>> listDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualWANInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<VirtualWANInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualWANInner>((Page)response.body()){

            public Page<VirtualWANInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualWANsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualWANInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<VirtualWANInner>> serviceFuture, ListOperationCallback<VirtualWANInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualWANInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualWANInner>>> call(String nextPageLink) {
                return VirtualWANsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualWANInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VirtualWANInner>>, Page<VirtualWANInner>>(){

            public Page<VirtualWANInner> call(ServiceResponse<Page<VirtualWANInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualWANInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualWANInner>>, Observable<ServiceResponse<Page<VirtualWANInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualWANInner>>> call(ServiceResponse<Page<VirtualWANInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualWANsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualWANInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualWANInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualWANInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualWANsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualWANInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualWANInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<VirtualWANInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualWANInner>((Page)response.body()){

            public Page<VirtualWANInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualWANsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualWANInner>> listNextAsync(String nextPageLink, ServiceFuture<List<VirtualWANInner>> serviceFuture, ListOperationCallback<VirtualWANInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualWANInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualWANInner>>> call(String nextPageLink) {
                return VirtualWANsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualWANInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VirtualWANInner>>, Page<VirtualWANInner>>(){

            public Page<VirtualWANInner> call(ServiceResponse<Page<VirtualWANInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualWANInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualWANInner>>, Observable<ServiceResponse<Page<VirtualWANInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualWANInner>>> call(ServiceResponse<Page<VirtualWANInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualWANsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualWANInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualWANInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualWANInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualWANsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualWANInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualWANInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    static interface VirtualWANsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualWANs getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{VirtualWANName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="VirtualWANName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualWANs createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{VirtualWANName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="VirtualWANName") String var3, @Query(value="api-version") String var4, @Body VirtualWANInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualWANs beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{VirtualWANName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="VirtualWANName") String var3, @Query(value="api-version") String var4, @Body VirtualWANInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualWANs updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{VirtualWANName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="VirtualWANName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualWANs beginUpdateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{VirtualWANName}")
        public Observable<Response<ResponseBody>> beginUpdateTags(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="VirtualWANName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualWANs delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{VirtualWANName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="VirtualWANName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualWANs beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{VirtualWANName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="VirtualWANName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualWANs listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualWANs list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/virtualWans")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualWANs listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualWANs listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

