/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.dag;

import com.microsoft.azure.management.resources.fluentcore.dag.DAGNode;
import com.microsoft.azure.management.resources.fluentcore.dag.ErroredDependencyTaskException;
import com.microsoft.azure.management.resources.fluentcore.dag.TaskGroup;
import com.microsoft.azure.management.resources.fluentcore.dag.TaskItem;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import rx.Observable;
import rx.functions.Func0;

final class TaskGroupEntry<TaskT extends TaskItem>
extends DAGNode<TaskT, TaskGroupEntry<TaskT>> {
    private TaskGroupEntry<TaskT> proxy;
    private boolean hasFaultedDescentDependencyTasks;

    TaskGroupEntry(String taskId, TaskT taskItem) {
        super(taskId, taskItem);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.hasFaultedDescentDependencyTasks = false;
    }

    public void setProxy(TaskGroupEntry<TaskT> proxy) {
        this.proxy = proxy;
    }

    public TaskGroupEntry<TaskT> proxy() {
        return this.proxy;
    }

    public Indexable taskResult() {
        return this.taskItem().result();
    }

    public boolean hasFaultedDescentDependencyTasks() {
        return this.hasFaultedDescentDependencyTasks;
    }

    public Observable<Indexable> invokeTaskAsync(boolean ignoreCachedResult, final TaskGroup.InvocationContext context) {
        if (this.hasFaultedDescentDependencyTasks) {
            return Observable.error((Throwable)new ErroredDependencyTaskException());
        }
        final TaskT taskItem = this.taskItem();
        if (!ignoreCachedResult && this.hasCachedResult()) {
            return Observable.just((Object)taskItem.result());
        }
        if (taskItem.isHot()) {
            return Observable.defer((Func0)new Func0<Observable<Indexable>>(){

                public Observable<Indexable> call() {
                    return taskItem.invokeAsync(context);
                }
            });
        }
        return taskItem.invokeAsync(context);
    }

    @Override
    protected void onFaultedResolution(String dependencyKey, Throwable throwable) {
        super.onFaultedResolution(dependencyKey, throwable);
        this.hasFaultedDescentDependencyTasks = true;
    }

    private TaskT taskItem() {
        return (TaskT)((TaskItem)super.data());
    }

    private boolean hasCachedResult() {
        return this.taskItem().result() != null;
    }
}

