/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.cdn.CdnProfile;
import com.microsoft.azure.management.cdn.CdnProfiles;
import com.microsoft.azure.management.cdn.CheckNameAvailabilityResult;
import com.microsoft.azure.management.cdn.EdgeNode;
import com.microsoft.azure.management.cdn.Operation;
import com.microsoft.azure.management.cdn.ResourceUsage;
import com.microsoft.azure.management.cdn.implementation.CdnManagementClientImpl;
import com.microsoft.azure.management.cdn.implementation.CdnManager;
import com.microsoft.azure.management.cdn.implementation.CdnProfileImpl;
import com.microsoft.azure.management.cdn.implementation.CheckNameAvailabilityOutputInner;
import com.microsoft.azure.management.cdn.implementation.EdgeNodeInner;
import com.microsoft.azure.management.cdn.implementation.OperationInner;
import com.microsoft.azure.management.cdn.implementation.ProfileInner;
import com.microsoft.azure.management.cdn.implementation.ProfilesInner;
import com.microsoft.azure.management.cdn.implementation.ResourceUsageInner;
import com.microsoft.azure.management.cdn.implementation.SsoUriInner;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class CdnProfilesImpl
extends TopLevelModifiableResourcesImpl<CdnProfile, CdnProfileImpl, ProfileInner, ProfilesInner, CdnManager>
implements CdnProfiles {
    CdnProfilesImpl(CdnManager cdnManager) {
        super((InnerSupportsListing)((CdnManagementClientImpl)((Object)cdnManager.inner())).profiles(), (ManagerBase)cdnManager);
    }

    protected CdnProfileImpl wrapModel(String name) {
        return new CdnProfileImpl(name, new ProfileInner(), (CdnManager)this.manager());
    }

    protected CdnProfileImpl wrapModel(ProfileInner inner) {
        if (inner == null) {
            return null;
        }
        return new CdnProfileImpl(inner.name(), inner, (CdnManager)this.manager());
    }

    public CdnProfileImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    public String generateSsoUri(String resourceGroupName, String profileName) {
        SsoUriInner ssoUri = ((CdnManagementClientImpl)((Object)((CdnManager)this.manager()).inner())).profiles().generateSsoUri(resourceGroupName, profileName);
        if (ssoUri != null) {
            return ssoUri.ssoUriValue();
        }
        return null;
    }

    @Override
    public CheckNameAvailabilityResult checkEndpointNameAvailability(String name) {
        return (CheckNameAvailabilityResult)this.checkEndpointNameAvailabilityAsync(name).toBlocking().last();
    }

    @Override
    public Observable<CheckNameAvailabilityResult> checkEndpointNameAvailabilityAsync(String name) {
        return ((CdnManagementClientImpl)((Object)((CdnManager)this.manager()).inner())).checkNameAvailabilityAsync(name).map((Func1)new Func1<CheckNameAvailabilityOutputInner, CheckNameAvailabilityResult>(){

            public CheckNameAvailabilityResult call(CheckNameAvailabilityOutputInner checkNameAvailabilityOutputInner) {
                return new CheckNameAvailabilityResult(checkNameAvailabilityOutputInner);
            }
        });
    }

    @Override
    public ServiceFuture<CheckNameAvailabilityResult> checkEndpointNameAvailabilityAsync(String name, ServiceCallback<CheckNameAvailabilityResult> callback) {
        return ServiceFuture.fromBody(this.checkEndpointNameAvailabilityAsync(name), callback);
    }

    @Override
    public PagedList<Operation> listOperations() {
        return new PagedListConverter<OperationInner, Operation>(){

            public Observable<Operation> typeConvertAsync(OperationInner inner) {
                return Observable.just((Object)new Operation(inner));
            }
        }.convert(((CdnManagementClientImpl)((Object)((CdnManager)this.manager()).inner())).operations().list());
    }

    @Override
    public PagedList<ResourceUsage> listResourceUsage() {
        return new PagedListConverter<ResourceUsageInner, ResourceUsage>(){

            public Observable<ResourceUsage> typeConvertAsync(ResourceUsageInner inner) {
                return Observable.just((Object)new ResourceUsage(inner));
            }
        }.convert(((CdnManagementClientImpl)((Object)((CdnManager)this.manager()).inner())).resourceUsages().list());
    }

    @Override
    public PagedList<EdgeNode> listEdgeNodes() {
        return new PagedListConverter<EdgeNodeInner, EdgeNode>(){

            public Observable<EdgeNode> typeConvertAsync(EdgeNodeInner inner) {
                return Observable.just((Object)new EdgeNode(inner));
            }
        }.convert(((CdnManagementClientImpl)((Object)((CdnManager)this.manager()).inner())).edgeNodes().list());
    }

    @Override
    public void startEndpoint(String resourceGroupName, String profileName, String endpointName) {
        ((CdnManagementClientImpl)((Object)((CdnManager)this.manager()).inner())).endpoints().start(resourceGroupName, profileName, endpointName);
    }

    @Override
    public void stopEndpoint(String resourceGroupName, String profileName, String endpointName) {
        ((CdnManagementClientImpl)((Object)((CdnManager)this.manager()).inner())).endpoints().stop(resourceGroupName, profileName, endpointName);
    }

    @Override
    public void purgeEndpointContent(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        ((CdnManagementClientImpl)((Object)((CdnManager)this.manager()).inner())).endpoints().purgeContent(resourceGroupName, profileName, endpointName, contentPaths);
    }

    @Override
    public void loadEndpointContent(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        ((CdnManagementClientImpl)((Object)((CdnManager)this.manager()).inner())).endpoints().loadContent(resourceGroupName, profileName, endpointName, contentPaths);
    }
}

