/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.ha;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.AuthInfo;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Charsets;
import org.apache.ranger.ha.HAConfiguration;
import org.apache.ranger.ha.ZookeeperSecurityProperties;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CuratorFactory.class);
    public static final String APACHE_HMS_TO_HDFS_METADATA_SYNC_LEADER_ELECTOR_PATH = "/leader_elector_path";
    public static final String SASL_SCHEME = "sasl";
    public static final String WORLD_SCHEME = "world";
    public static final String ANYONE_ID = "anyone";
    public static final String AUTH_SCHEME = "auth";
    public static final String DIGEST_SCHEME = "digest";
    public static final String IP_SCHEME = "ip";
    public static final String SETUP_LOCK = "/setup_lock";
    private final Configuration configuration;
    private CuratorFramework curatorFramework;
    private static CuratorFactory instance;

    private CuratorFactory(Configuration configuration) {
        this.configuration = configuration;
        if (HAConfiguration.isHAEnabled(configuration)) {
            this.initializeCuratorFramework();
        } else {
            LOG.info("HA is not enabled so not initialising curator framework");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CuratorFactory getInstance(Configuration configuration) {
        if (instance != null) return instance;
        Class<CuratorFactory> clazz = CuratorFactory.class;
        synchronized (CuratorFactory.class) {
            if (instance != null) return instance;
            try {
                instance = new CuratorFactory(configuration);
            }
            catch (Exception e) {
                LOG.error("HA is not enabled so not initialising curator CuratorFactory", (Throwable)e);
            }
            return instance;
        }
    }

    @VisibleForTesting
    protected void initializeCuratorFramework() {
        HAConfiguration.ZookeeperProperties zookeeperProperties = HAConfiguration.getZookeeperProperties(this.configuration);
        CuratorFrameworkFactory.Builder builder = this.getBuilder(zookeeperProperties);
        this.enhanceBuilderWithSecurityParameters(zookeeperProperties, builder);
        this.curatorFramework = builder.build();
        this.curatorFramework.start();
    }

    @VisibleForTesting
    void enhanceBuilderWithSecurityParameters(HAConfiguration.ZookeeperProperties zookeeperProperties, CuratorFrameworkFactory.Builder builder) {
        ACLProvider aclProvider = this.getAclProvider(zookeeperProperties);
        AuthInfo authInfo = null;
        if (zookeeperProperties.hasAuth()) {
            authInfo = ZookeeperSecurityProperties.parseAuth(zookeeperProperties.getAuth());
        }
        if (aclProvider != null) {
            LOG.info("Setting up acl provider.");
            builder.aclProvider(aclProvider);
            if (authInfo != null) {
                byte[] auth = authInfo.getAuth();
                LOG.info("Setting up auth provider with scheme: {} and id: {} ", (Object)authInfo.getScheme(), (Object)this.getIdForLogging(authInfo.getScheme(), new String(auth, Charsets.UTF_8)));
                builder.authorization(authInfo.getScheme(), auth);
            }
        }
    }

    private String getCurrentUser() {
        try {
            return UserGroupInformation.getCurrentUser().getUserName();
        }
        catch (IOException ioe) {
            return "unknown";
        }
    }

    private ACLProvider getAclProvider(HAConfiguration.ZookeeperProperties zookeeperProperties) {
        ACLProvider aclProvider = null;
        if (zookeeperProperties.hasAcl()) {
            ACL acl = ZookeeperSecurityProperties.parseAcl(zookeeperProperties.getAcl());
            LOG.info("Setting ACL for id: {} with scheme: {} and perms: {}.", new Object[]{this.getIdForLogging(acl.getId().getScheme(), acl.getId().getId()), acl.getId().getScheme(), acl.getPerms()});
            LOG.info("Current logged in user: {}", (Object)this.getCurrentUser());
            final List<ACL> acls = Arrays.asList(acl);
            aclProvider = new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return acls;
                }

                public List<ACL> getAclForPath(String path) {
                    return acls;
                }
            };
        }
        return aclProvider;
    }

    private String getIdForLogging(String scheme, String id) {
        if (scheme.equalsIgnoreCase(SASL_SCHEME) || scheme.equalsIgnoreCase(IP_SCHEME)) {
            return id;
        }
        if (scheme.equalsIgnoreCase(WORLD_SCHEME)) {
            return ANYONE_ID;
        }
        if (scheme.equalsIgnoreCase(AUTH_SCHEME) || scheme.equalsIgnoreCase(DIGEST_SCHEME)) {
            return id.split(":")[0];
        }
        return "unknown";
    }

    private CuratorFrameworkFactory.Builder getBuilder(HAConfiguration.ZookeeperProperties zookeeperProperties) {
        return CuratorFrameworkFactory.builder().connectString(zookeeperProperties.getConnectString()).sessionTimeoutMs(zookeeperProperties.getSessionTimeout()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(zookeeperProperties.getRetriesSleepTimeMillis(), zookeeperProperties.getNumRetries()));
    }

    public void close() {
        if (this.curatorFramework != null) {
            this.curatorFramework.close();
        }
    }

    public CuratorFramework clientInstance() {
        return this.curatorFramework;
    }

    public LeaderLatch leaderLatchInstance(String serverId, String zkRoot) {
        LOG.info("CuratorFactory.leaderLatchInstance() creating LeaderLatch for serverId {} and zkRoot: {}", (Object)serverId, (Object)zkRoot);
        return new LeaderLatch(this.curatorFramework, zkRoot + APACHE_HMS_TO_HDFS_METADATA_SYNC_LEADER_ELECTOR_PATH, serverId);
    }

    public InterProcessMutex lockInstance(String zkRoot) {
        return new InterProcessMutex(this.curatorFramework, zkRoot + SETUP_LOCK);
    }
}

