/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.ElasticPoolOperationInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ElasticPoolOperationsInner {
    private ElasticPoolOperationsService service;
    private SqlManagementClientImpl client;

    public ElasticPoolOperationsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ElasticPoolOperationsService)retrofit.create(ElasticPoolOperationsService.class);
        this.client = client;
    }

    public void cancel(String resourceGroupName, String serverName, String elasticPoolName, UUID operationId) {
        ((ServiceResponse)this.cancelWithServiceResponseAsync(resourceGroupName, serverName, elasticPoolName, operationId).toBlocking().single()).body();
    }

    public ServiceFuture<Void> cancelAsync(String resourceGroupName, String serverName, String elasticPoolName, UUID operationId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.cancelWithServiceResponseAsync(resourceGroupName, serverName, elasticPoolName, operationId), serviceCallback);
    }

    public Observable<Void> cancelAsync(String resourceGroupName, String serverName, String elasticPoolName, UUID operationId) {
        return this.cancelWithServiceResponseAsync(resourceGroupName, serverName, elasticPoolName, operationId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> cancelWithServiceResponseAsync(String resourceGroupName, String serverName, String elasticPoolName, UUID operationId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (elasticPoolName == null) {
            throw new IllegalArgumentException("Parameter elasticPoolName is required and cannot be null.");
        }
        if (operationId == null) {
            throw new IllegalArgumentException("Parameter operationId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-10-01-preview";
        return this.service.cancel(resourceGroupName, serverName, elasticPoolName, operationId, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ElasticPoolOperationsInner.this.cancelDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> cancelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ElasticPoolOperationInner> listByElasticPool(String resourceGroupName, String serverName, String elasticPoolName) {
        ServiceResponse response = (ServiceResponse)this.listByElasticPoolSinglePageAsync(resourceGroupName, serverName, elasticPoolName).toBlocking().single();
        return new PagedList<ElasticPoolOperationInner>((Page)response.body()){

            public Page<ElasticPoolOperationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ElasticPoolOperationsInner.this.listByElasticPoolNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ElasticPoolOperationInner>> listByElasticPoolAsync(String resourceGroupName, String serverName, String elasticPoolName, ListOperationCallback<ElasticPoolOperationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByElasticPoolSinglePageAsync(resourceGroupName, serverName, elasticPoolName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ElasticPoolOperationInner>>>>(){

            public Observable<ServiceResponse<Page<ElasticPoolOperationInner>>> call(String nextPageLink) {
                return ElasticPoolOperationsInner.this.listByElasticPoolNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ElasticPoolOperationInner>> listByElasticPoolAsync(String resourceGroupName, String serverName, String elasticPoolName) {
        return this.listByElasticPoolWithServiceResponseAsync(resourceGroupName, serverName, elasticPoolName).map((Func1)new Func1<ServiceResponse<Page<ElasticPoolOperationInner>>, Page<ElasticPoolOperationInner>>(){

            public Page<ElasticPoolOperationInner> call(ServiceResponse<Page<ElasticPoolOperationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ElasticPoolOperationInner>>> listByElasticPoolWithServiceResponseAsync(String resourceGroupName, String serverName, String elasticPoolName) {
        return this.listByElasticPoolSinglePageAsync(resourceGroupName, serverName, elasticPoolName).concatMap((Func1)new Func1<ServiceResponse<Page<ElasticPoolOperationInner>>, Observable<ServiceResponse<Page<ElasticPoolOperationInner>>>>(){

            public Observable<ServiceResponse<Page<ElasticPoolOperationInner>>> call(ServiceResponse<Page<ElasticPoolOperationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ElasticPoolOperationsInner.this.listByElasticPoolNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ElasticPoolOperationInner>>> listByElasticPoolSinglePageAsync(String resourceGroupName, String serverName, String elasticPoolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (elasticPoolName == null) {
            throw new IllegalArgumentException("Parameter elasticPoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-10-01-preview";
        return this.service.listByElasticPool(resourceGroupName, serverName, elasticPoolName, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ElasticPoolOperationInner>>>>(){

            public Observable<ServiceResponse<Page<ElasticPoolOperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ElasticPoolOperationsInner.this.listByElasticPoolDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ElasticPoolOperationInner>> listByElasticPoolDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ElasticPoolOperationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ElasticPoolOperationInner> listByElasticPoolNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByElasticPoolNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ElasticPoolOperationInner>((Page)response.body()){

            public Page<ElasticPoolOperationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ElasticPoolOperationsInner.this.listByElasticPoolNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ElasticPoolOperationInner>> listByElasticPoolNextAsync(String nextPageLink, ServiceFuture<List<ElasticPoolOperationInner>> serviceFuture, ListOperationCallback<ElasticPoolOperationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByElasticPoolNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ElasticPoolOperationInner>>>>(){

            public Observable<ServiceResponse<Page<ElasticPoolOperationInner>>> call(String nextPageLink) {
                return ElasticPoolOperationsInner.this.listByElasticPoolNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ElasticPoolOperationInner>> listByElasticPoolNextAsync(String nextPageLink) {
        return this.listByElasticPoolNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ElasticPoolOperationInner>>, Page<ElasticPoolOperationInner>>(){

            public Page<ElasticPoolOperationInner> call(ServiceResponse<Page<ElasticPoolOperationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ElasticPoolOperationInner>>> listByElasticPoolNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByElasticPoolNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ElasticPoolOperationInner>>, Observable<ServiceResponse<Page<ElasticPoolOperationInner>>>>(){

            public Observable<ServiceResponse<Page<ElasticPoolOperationInner>>> call(ServiceResponse<Page<ElasticPoolOperationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ElasticPoolOperationsInner.this.listByElasticPoolNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ElasticPoolOperationInner>>> listByElasticPoolNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByElasticPoolNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ElasticPoolOperationInner>>>>(){

            public Observable<ServiceResponse<Page<ElasticPoolOperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ElasticPoolOperationsInner.this.listByElasticPoolNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ElasticPoolOperationInner>> listByElasticPoolNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ElasticPoolOperationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ElasticPoolOperationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ElasticPoolOperations cancel"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}/operations/{operationId}/cancel")
        public Observable<Response<ResponseBody>> cancel(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="elasticPoolName") String var3, @Path(value="operationId") UUID var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ElasticPoolOperations listByElasticPool"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}/operations")
        public Observable<Response<ResponseBody>> listByElasticPool(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="elasticPoolName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ElasticPoolOperations listByElasticPoolNext"})
        @GET
        public Observable<Response<ResponseBody>> listByElasticPoolNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

