/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.microsoft.azure.management.sql.TransparentDataEncryption;
import com.microsoft.azure.management.sql.TransparentDataEncryptionActivity;
import com.microsoft.azure.management.sql.TransparentDataEncryptionStates;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import com.microsoft.azure.management.sql.implementation.TransparentDataEncryptionActivityImpl;
import com.microsoft.azure.management.sql.implementation.TransparentDataEncryptionActivityInner;
import com.microsoft.azure.management.sql.implementation.TransparentDataEncryptionInner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class TransparentDataEncryptionImpl
extends RefreshableWrapperImpl<TransparentDataEncryptionInner, TransparentDataEncryption>
implements TransparentDataEncryption {
    private final String sqlServerName;
    private final String resourceGroupName;
    private final SqlServerManager sqlServerManager;
    private final ResourceId resourceId;

    protected TransparentDataEncryptionImpl(String resourceGroupName, String sqlServerName, TransparentDataEncryptionInner innerObject, SqlServerManager sqlServerManager) {
        super((Object)innerObject);
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerManager = sqlServerManager;
        this.resourceId = ResourceId.fromString((String)((TransparentDataEncryptionInner)this.inner()).id());
    }

    public String name() {
        return ((TransparentDataEncryptionInner)this.inner()).name();
    }

    public String id() {
        return ((TransparentDataEncryptionInner)this.inner()).id();
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String databaseName() {
        return this.resourceId.parent().name();
    }

    @Override
    public TransparentDataEncryptionStates status() {
        return ((TransparentDataEncryptionInner)this.inner()).status();
    }

    @Override
    public TransparentDataEncryption updateStatus(TransparentDataEncryptionStates transparentDataEncryptionState) {
        ((TransparentDataEncryptionInner)this.inner()).withStatus(transparentDataEncryptionState);
        TransparentDataEncryptionInner transparentDataEncryptionInner = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).transparentDataEncryptions().createOrUpdate(this.resourceGroupName, this.sqlServerName, this.databaseName(), transparentDataEncryptionState);
        this.setInner(transparentDataEncryptionInner);
        return this;
    }

    @Override
    public Observable<TransparentDataEncryption> updateStatusAsync(TransparentDataEncryptionStates transparentDataEncryptionState) {
        final TransparentDataEncryptionImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).transparentDataEncryptions().createOrUpdateAsync(self.resourceGroupName, self.sqlServerName, self.databaseName(), transparentDataEncryptionState).map((Func1)new Func1<TransparentDataEncryptionInner, TransparentDataEncryption>(){

            public TransparentDataEncryption call(TransparentDataEncryptionInner transparentDataEncryptionInner) {
                self.setInner(transparentDataEncryptionInner);
                return self;
            }
        });
    }

    @Override
    public List<TransparentDataEncryptionActivity> listActivities() {
        ArrayList<TransparentDataEncryptionActivityImpl> transparentDataEncryptionActivities = new ArrayList<TransparentDataEncryptionActivityImpl>();
        List<TransparentDataEncryptionActivityInner> transparentDataEncryptionActivityInners = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).transparentDataEncryptionActivities().listByConfiguration(this.resourceGroupName, this.sqlServerName, this.databaseName());
        if (transparentDataEncryptionActivityInners != null) {
            for (TransparentDataEncryptionActivityInner transparentDataEncryptionActivityInner : transparentDataEncryptionActivityInners) {
                transparentDataEncryptionActivities.add(new TransparentDataEncryptionActivityImpl(transparentDataEncryptionActivityInner));
            }
        }
        return Collections.unmodifiableList(transparentDataEncryptionActivities);
    }

    @Override
    public Observable<TransparentDataEncryptionActivity> listActivitiesAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).transparentDataEncryptionActivities().listByConfigurationAsync(this.resourceGroupName, this.sqlServerName, this.databaseName()).flatMap((Func1)new Func1<List<TransparentDataEncryptionActivityInner>, Observable<TransparentDataEncryptionActivityInner>>(){

            public Observable<TransparentDataEncryptionActivityInner> call(List<TransparentDataEncryptionActivityInner> transparentDataEncryptionActivityInners) {
                return Observable.from(transparentDataEncryptionActivityInners);
            }
        }).map((Func1)new Func1<TransparentDataEncryptionActivityInner, TransparentDataEncryptionActivity>(){

            public TransparentDataEncryptionActivity call(TransparentDataEncryptionActivityInner transparentDataEncryptionActivityInner) {
                return new TransparentDataEncryptionActivityImpl(transparentDataEncryptionActivityInner);
            }
        });
    }

    protected Observable<TransparentDataEncryptionInner> getInnerAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).transparentDataEncryptions().getAsync(this.resourceGroupName, this.sqlServerName, this.databaseName());
    }
}

