/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.Access;
import com.microsoft.azure.management.network.ExpressRouteCircuitPeering;
import com.microsoft.azure.management.network.RouteFilter;
import com.microsoft.azure.management.network.RouteFilterRule;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.RouteFilterInner;
import com.microsoft.azure.management.network.implementation.RouteFilterRuleImpl;
import com.microsoft.azure.management.network.implementation.RouteFilterRuleInner;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableParentResourceImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class RouteFilterImpl
extends GroupableParentResourceImpl<RouteFilter, RouteFilterInner, RouteFilterImpl, NetworkManager>
implements RouteFilter,
RouteFilter.Definition,
RouteFilter.Update {
    private static final String RULE_TYPE = "Community";
    private Map<String, RouteFilterRule> rules;
    private Map<String, ExpressRouteCircuitPeering> peerings;

    RouteFilterImpl(String name, RouteFilterInner innerModel, NetworkManager networkManager) {
        super(name, (Resource)innerModel, (ManagerBase)networkManager);
    }

    protected Observable<RouteFilterInner> createInner() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).routeFilters().createOrUpdateAsync(this.resourceGroupName(), this.name(), (RouteFilterInner)((Object)this.inner()));
    }

    protected void initializeChildrenFromInner() {
        this.rules = new TreeMap<String, RouteFilterRule>();
        List<RouteFilterRuleInner> inners = ((RouteFilterInner)((Object)this.inner())).rules();
        if (inners != null) {
            for (RouteFilterRuleInner inner : inners) {
                this.rules.put(inner.name(), new RouteFilterRuleImpl(inner, this));
            }
        }
    }

    protected void beforeCreating() {
        ((RouteFilterInner)((Object)this.inner())).withRules(this.innersFromWrappers(this.rules.values()));
    }

    protected void afterCreating() {
    }

    protected Observable<RouteFilterInner> getInnerAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)this.manager()).inner())).routeFilters().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Observable<RouteFilter> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<RouteFilter, RouteFilter>(){

            public RouteFilter call(RouteFilter routeFilter) {
                RouteFilterImpl impl = (RouteFilterImpl)routeFilter;
                impl.initializeChildrenFromInner();
                return impl;
            }
        });
    }

    @Override
    public String provisioningState() {
        return ((RouteFilterInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public Map<String, RouteFilterRule> rules() {
        return Collections.unmodifiableMap(this.rules);
    }

    @Override
    public Map<String, ExpressRouteCircuitPeering> peerings() {
        return Collections.unmodifiableMap(this.peerings);
    }

    RouteFilterImpl withRule(RouteFilterRuleImpl rule) {
        this.rules.put(rule.name(), rule);
        return this;
    }

    @Override
    public RouteFilter.Update withoutRule(String name) {
        this.rules.remove(name);
        return this;
    }

    public RouteFilterRuleImpl defineRule(String name) {
        RouteFilterRuleInner inner = new RouteFilterRuleInner();
        inner.withName(name);
        inner.withRouteFilterRuleType(RULE_TYPE);
        inner.withAccess(Access.ALLOW);
        return new RouteFilterRuleImpl(inner, this);
    }

    @Override
    public RouteFilterRule.Update updateRule(String name) {
        return (RouteFilterRuleImpl)this.rules.get(name);
    }
}

