/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.VpnSiteInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class VpnSitesInner
implements InnerSupportsGet<VpnSiteInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<VpnSiteInner> {
    private VpnSitesService service;
    private NetworkManagementClientImpl client;

    public VpnSitesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (VpnSitesService)retrofit.create(VpnSitesService.class);
        this.client = client;
    }

    public VpnSiteInner getByResourceGroup(String resourceGroupName, String vpnSiteName) {
        return (VpnSiteInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, vpnSiteName).toBlocking().single()).body());
    }

    public ServiceFuture<VpnSiteInner> getByResourceGroupAsync(String resourceGroupName, String vpnSiteName, ServiceCallback<VpnSiteInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, vpnSiteName), serviceCallback);
    }

    public Observable<VpnSiteInner> getByResourceGroupAsync(String resourceGroupName, String vpnSiteName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, vpnSiteName).map((Func1)new Func1<ServiceResponse<VpnSiteInner>, VpnSiteInner>(){

            public VpnSiteInner call(ServiceResponse<VpnSiteInner> response) {
                return (VpnSiteInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnSiteInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String vpnSiteName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnSiteName == null) {
            throw new IllegalArgumentException("Parameter vpnSiteName is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, vpnSiteName, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnSiteInner>>>(){

            public Observable<ServiceResponse<VpnSiteInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnSitesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VpnSiteInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VpnSiteInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public VpnSiteInner createOrUpdate(String resourceGroupName, String vpnSiteName, VpnSiteInner vpnSiteParameters) {
        return (VpnSiteInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vpnSiteName, vpnSiteParameters).toBlocking().last()).body());
    }

    public ServiceFuture<VpnSiteInner> createOrUpdateAsync(String resourceGroupName, String vpnSiteName, VpnSiteInner vpnSiteParameters, ServiceCallback<VpnSiteInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vpnSiteName, vpnSiteParameters), serviceCallback);
    }

    public Observable<VpnSiteInner> createOrUpdateAsync(String resourceGroupName, String vpnSiteName, VpnSiteInner vpnSiteParameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vpnSiteName, vpnSiteParameters).map((Func1)new Func1<ServiceResponse<VpnSiteInner>, VpnSiteInner>(){

            public VpnSiteInner call(ServiceResponse<VpnSiteInner> response) {
                return (VpnSiteInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnSiteInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String vpnSiteName, VpnSiteInner vpnSiteParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnSiteName == null) {
            throw new IllegalArgumentException("Parameter vpnSiteName is required and cannot be null.");
        }
        if (vpnSiteParameters == null) {
            throw new IllegalArgumentException("Parameter vpnSiteParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)vpnSiteParameters));
        String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, vpnSiteName, "2018-06-01", vpnSiteParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VpnSiteInner>(){}.getType());
    }

    public VpnSiteInner beginCreateOrUpdate(String resourceGroupName, String vpnSiteName, VpnSiteInner vpnSiteParameters) {
        return (VpnSiteInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vpnSiteName, vpnSiteParameters).toBlocking().single()).body());
    }

    public ServiceFuture<VpnSiteInner> beginCreateOrUpdateAsync(String resourceGroupName, String vpnSiteName, VpnSiteInner vpnSiteParameters, ServiceCallback<VpnSiteInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vpnSiteName, vpnSiteParameters), serviceCallback);
    }

    public Observable<VpnSiteInner> beginCreateOrUpdateAsync(String resourceGroupName, String vpnSiteName, VpnSiteInner vpnSiteParameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vpnSiteName, vpnSiteParameters).map((Func1)new Func1<ServiceResponse<VpnSiteInner>, VpnSiteInner>(){

            public VpnSiteInner call(ServiceResponse<VpnSiteInner> response) {
                return (VpnSiteInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnSiteInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String vpnSiteName, VpnSiteInner vpnSiteParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnSiteName == null) {
            throw new IllegalArgumentException("Parameter vpnSiteName is required and cannot be null.");
        }
        if (vpnSiteParameters == null) {
            throw new IllegalArgumentException("Parameter vpnSiteParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)vpnSiteParameters));
        String apiVersion = "2018-06-01";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, vpnSiteName, "2018-06-01", vpnSiteParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnSiteInner>>>(){

            public Observable<ServiceResponse<VpnSiteInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnSitesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VpnSiteInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VpnSiteInner>(){}.getType()).register(201, new TypeToken<VpnSiteInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public VpnSiteInner updateTags(String resourceGroupName, String vpnSiteName) {
        return (VpnSiteInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, vpnSiteName).toBlocking().last()).body());
    }

    public ServiceFuture<VpnSiteInner> updateTagsAsync(String resourceGroupName, String vpnSiteName, ServiceCallback<VpnSiteInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, vpnSiteName), serviceCallback);
    }

    public Observable<VpnSiteInner> updateTagsAsync(String resourceGroupName, String vpnSiteName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, vpnSiteName).map((Func1)new Func1<ServiceResponse<VpnSiteInner>, VpnSiteInner>(){

            public VpnSiteInner call(ServiceResponse<VpnSiteInner> response) {
                return (VpnSiteInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnSiteInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String vpnSiteName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnSiteName == null) {
            throw new IllegalArgumentException("Parameter vpnSiteName is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        Object tags = null;
        TagsObject vpnSiteParameters = new TagsObject();
        vpnSiteParameters.withTags(null);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(this.client.subscriptionId(), resourceGroupName, vpnSiteName, "2018-06-01", this.client.acceptLanguage(), vpnSiteParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VpnSiteInner>(){}.getType());
    }

    public VpnSiteInner updateTags(String resourceGroupName, String vpnSiteName, Map<String, String> tags) {
        return (VpnSiteInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, vpnSiteName, tags).toBlocking().last()).body());
    }

    public ServiceFuture<VpnSiteInner> updateTagsAsync(String resourceGroupName, String vpnSiteName, Map<String, String> tags, ServiceCallback<VpnSiteInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, vpnSiteName, tags), serviceCallback);
    }

    public Observable<VpnSiteInner> updateTagsAsync(String resourceGroupName, String vpnSiteName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, vpnSiteName, tags).map((Func1)new Func1<ServiceResponse<VpnSiteInner>, VpnSiteInner>(){

            public VpnSiteInner call(ServiceResponse<VpnSiteInner> response) {
                return (VpnSiteInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnSiteInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String vpnSiteName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnSiteName == null) {
            throw new IllegalArgumentException("Parameter vpnSiteName is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2018-06-01";
        TagsObject vpnSiteParameters = new TagsObject();
        vpnSiteParameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(this.client.subscriptionId(), resourceGroupName, vpnSiteName, "2018-06-01", this.client.acceptLanguage(), vpnSiteParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VpnSiteInner>(){}.getType());
    }

    public VpnSiteInner beginUpdateTags(String resourceGroupName, String vpnSiteName) {
        return (VpnSiteInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, vpnSiteName).toBlocking().single()).body());
    }

    public ServiceFuture<VpnSiteInner> beginUpdateTagsAsync(String resourceGroupName, String vpnSiteName, ServiceCallback<VpnSiteInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, vpnSiteName), serviceCallback);
    }

    public Observable<VpnSiteInner> beginUpdateTagsAsync(String resourceGroupName, String vpnSiteName) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, vpnSiteName).map((Func1)new Func1<ServiceResponse<VpnSiteInner>, VpnSiteInner>(){

            public VpnSiteInner call(ServiceResponse<VpnSiteInner> response) {
                return (VpnSiteInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnSiteInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String vpnSiteName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnSiteName == null) {
            throw new IllegalArgumentException("Parameter vpnSiteName is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        Object tags = null;
        TagsObject vpnSiteParameters = new TagsObject();
        vpnSiteParameters.withTags(null);
        return this.service.beginUpdateTags(this.client.subscriptionId(), resourceGroupName, vpnSiteName, "2018-06-01", this.client.acceptLanguage(), vpnSiteParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnSiteInner>>>(){

            public Observable<ServiceResponse<VpnSiteInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnSitesInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public VpnSiteInner beginUpdateTags(String resourceGroupName, String vpnSiteName, Map<String, String> tags) {
        return (VpnSiteInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, vpnSiteName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<VpnSiteInner> beginUpdateTagsAsync(String resourceGroupName, String vpnSiteName, Map<String, String> tags, ServiceCallback<VpnSiteInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, vpnSiteName, tags), serviceCallback);
    }

    public Observable<VpnSiteInner> beginUpdateTagsAsync(String resourceGroupName, String vpnSiteName, Map<String, String> tags) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, vpnSiteName, tags).map((Func1)new Func1<ServiceResponse<VpnSiteInner>, VpnSiteInner>(){

            public VpnSiteInner call(ServiceResponse<VpnSiteInner> response) {
                return (VpnSiteInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnSiteInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String vpnSiteName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnSiteName == null) {
            throw new IllegalArgumentException("Parameter vpnSiteName is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2018-06-01";
        TagsObject vpnSiteParameters = new TagsObject();
        vpnSiteParameters.withTags(tags);
        return this.service.beginUpdateTags(this.client.subscriptionId(), resourceGroupName, vpnSiteName, "2018-06-01", this.client.acceptLanguage(), vpnSiteParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnSiteInner>>>(){

            public Observable<ServiceResponse<VpnSiteInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnSitesInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VpnSiteInner> beginUpdateTagsDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VpnSiteInner>(){}.getType()).register(201, new TypeToken<VpnSiteInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public void delete(String resourceGroupName, String vpnSiteName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, vpnSiteName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String vpnSiteName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, vpnSiteName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String vpnSiteName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, vpnSiteName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String vpnSiteName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnSiteName == null) {
            throw new IllegalArgumentException("Parameter vpnSiteName is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, vpnSiteName, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String vpnSiteName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, vpnSiteName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String vpnSiteName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, vpnSiteName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String vpnSiteName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, vpnSiteName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String vpnSiteName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnSiteName == null) {
            throw new IllegalArgumentException("Parameter vpnSiteName is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, vpnSiteName, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnSitesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<VpnSiteInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<VpnSiteInner>((Page)response.body()){

            public Page<VpnSiteInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VpnSitesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VpnSiteInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<VpnSiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<VpnSiteInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteInner>>> call(String nextPageLink) {
                return VpnSitesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VpnSiteInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<VpnSiteInner>>, Page<VpnSiteInner>>(){

            public Page<VpnSiteInner> call(ServiceResponse<Page<VpnSiteInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnSiteInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<VpnSiteInner>>, Observable<ServiceResponse<Page<VpnSiteInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteInner>>> call(ServiceResponse<Page<VpnSiteInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VpnSitesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnSiteInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnSiteInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VpnSitesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VpnSiteInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VpnSiteInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<VpnSiteInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<VpnSiteInner>((Page)response.body()){

            public Page<VpnSiteInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VpnSitesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VpnSiteInner>> listAsync(ListOperationCallback<VpnSiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<VpnSiteInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteInner>>> call(String nextPageLink) {
                return VpnSitesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VpnSiteInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<VpnSiteInner>>, Page<VpnSiteInner>>(){

            public Page<VpnSiteInner> call(ServiceResponse<Page<VpnSiteInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnSiteInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<VpnSiteInner>>, Observable<ServiceResponse<Page<VpnSiteInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteInner>>> call(ServiceResponse<Page<VpnSiteInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VpnSitesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnSiteInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.list(this.client.subscriptionId(), "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnSiteInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VpnSitesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VpnSiteInner>> listDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VpnSiteInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<VpnSiteInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VpnSiteInner>((Page)response.body()){

            public Page<VpnSiteInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VpnSitesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VpnSiteInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<VpnSiteInner>> serviceFuture, ListOperationCallback<VpnSiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VpnSiteInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteInner>>> call(String nextPageLink) {
                return VpnSitesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VpnSiteInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VpnSiteInner>>, Page<VpnSiteInner>>(){

            public Page<VpnSiteInner> call(ServiceResponse<Page<VpnSiteInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnSiteInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VpnSiteInner>>, Observable<ServiceResponse<Page<VpnSiteInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteInner>>> call(ServiceResponse<Page<VpnSiteInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VpnSitesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnSiteInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnSiteInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VpnSitesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VpnSiteInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VpnSiteInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<VpnSiteInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VpnSiteInner>((Page)response.body()){

            public Page<VpnSiteInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VpnSitesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VpnSiteInner>> listNextAsync(String nextPageLink, ServiceFuture<List<VpnSiteInner>> serviceFuture, ListOperationCallback<VpnSiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VpnSiteInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteInner>>> call(String nextPageLink) {
                return VpnSitesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VpnSiteInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VpnSiteInner>>, Page<VpnSiteInner>>(){

            public Page<VpnSiteInner> call(ServiceResponse<Page<VpnSiteInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnSiteInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VpnSiteInner>>, Observable<ServiceResponse<Page<VpnSiteInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteInner>>> call(ServiceResponse<Page<VpnSiteInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VpnSitesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnSiteInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnSiteInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VpnSitesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VpnSiteInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VpnSiteInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    static interface VpnSitesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSites getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnSites/{vpnSiteName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="vpnSiteName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSites createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnSites/{vpnSiteName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="vpnSiteName") String var3, @Query(value="api-version") String var4, @Body VpnSiteInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSites beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnSites/{vpnSiteName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="vpnSiteName") String var3, @Query(value="api-version") String var4, @Body VpnSiteInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSites updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnSites/{vpnSiteName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="vpnSiteName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSites beginUpdateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnSites/{vpnSiteName}")
        public Observable<Response<ResponseBody>> beginUpdateTags(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="vpnSiteName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSites delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnSites/{vpnSiteName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="vpnSiteName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSites beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnSites/{vpnSiteName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="vpnSiteName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSites listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnSites")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSites list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/vpnSites")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSites listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnSites listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

