/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.servicebus.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.servicebus.ServiceBusSubscription;
import com.microsoft.azure.management.servicebus.ServiceBusSubscriptions;
import com.microsoft.azure.management.servicebus.Topic;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusChildResourcesImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManagementClientImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManager;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusSubscriptionImpl;
import com.microsoft.azure.management.servicebus.implementation.SubscriptionInner;
import com.microsoft.azure.management.servicebus.implementation.SubscriptionsInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import rx.Completable;
import rx.Observable;

@LangDefinition
class ServiceBusSubscriptionsImpl
extends ServiceBusChildResourcesImpl<ServiceBusSubscription, ServiceBusSubscriptionImpl, SubscriptionInner, SubscriptionsInner, ServiceBusManager, Topic>
implements ServiceBusSubscriptions {
    private final String resourceGroupName;
    private final String namespaceName;
    private final String topicName;
    private final Region region;

    protected ServiceBusSubscriptionsImpl(String resourceGroupName, String namespaceName, String topicName, Region region, ServiceBusManager manager) {
        super(((ServiceBusManagementClientImpl)((Object)manager.inner())).subscriptions(), manager);
        this.resourceGroupName = resourceGroupName;
        this.namespaceName = namespaceName;
        this.topicName = topicName;
        this.region = region;
    }

    public ServiceBusSubscriptionImpl define(String name) {
        return this.wrapModel(name);
    }

    public Completable deleteByNameAsync(String name) {
        return ((SubscriptionsInner)this.inner()).deleteAsync(this.resourceGroupName, this.namespaceName, this.topicName, name).toCompletable();
    }

    public ServiceFuture<Void> deleteByNameAsync(String name, ServiceCallback<Void> callback) {
        return ((SubscriptionsInner)this.inner()).deleteAsync(this.resourceGroupName, this.namespaceName, this.topicName, name, callback);
    }

    @Override
    protected Observable<SubscriptionInner> getInnerByNameAsync(String name) {
        return ((SubscriptionsInner)this.inner()).getAsync(this.resourceGroupName, this.namespaceName, this.topicName, name);
    }

    @Override
    protected Observable<ServiceResponse<Page<SubscriptionInner>>> listInnerAsync() {
        return ((SubscriptionsInner)this.inner()).listByTopicWithServiceResponseAsync(this.resourceGroupName, this.namespaceName, this.topicName);
    }

    @Override
    protected PagedList<SubscriptionInner> listInner() {
        return ((SubscriptionsInner)this.inner()).listByTopic(this.resourceGroupName, this.namespaceName, this.topicName);
    }

    protected ServiceBusSubscriptionImpl wrapModel(String name) {
        return new ServiceBusSubscriptionImpl(this.resourceGroupName, this.namespaceName, this.topicName, name, this.region, new SubscriptionInner(), (ServiceBusManager)this.manager());
    }

    protected ServiceBusSubscriptionImpl wrapModel(SubscriptionInner inner) {
        return new ServiceBusSubscriptionImpl(this.resourceGroupName, this.namespaceName, this.topicName, inner.name(), this.region, inner, (ServiceBusManager)this.manager());
    }

    public PagedList<ServiceBusSubscription> listByParent(String resourceGroupName, String parentName) {
        throw new UnsupportedOperationException();
    }

    public Completable deleteByParentAsync(String groupName, String parentName, String name) {
        throw new UnsupportedOperationException();
    }

    public Observable<ServiceBusSubscription> getByParentAsync(String resourceGroup, String parentName, String name) {
        throw new UnsupportedOperationException();
    }
}

