/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.cryptography;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.microsoft.azure.keyvault.core.IKey;
import com.microsoft.azure.keyvault.cryptography.Algorithm;
import com.microsoft.azure.keyvault.cryptography.AlgorithmResolver;
import com.microsoft.azure.keyvault.cryptography.ByteExtensions;
import com.microsoft.azure.keyvault.cryptography.IAuthenticatedCryptoTransform;
import com.microsoft.azure.keyvault.cryptography.ICryptoTransform;
import com.microsoft.azure.keyvault.cryptography.KeyWrapAlgorithm;
import com.microsoft.azure.keyvault.cryptography.Strings;
import com.microsoft.azure.keyvault.cryptography.SymmetricEncryptionAlgorithm;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.UUID;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class SymmetricKey
implements IKey {
    private static final SecureRandom Rng = new SecureRandom();
    public static final int KeySize128 = 16;
    public static final int KeySize192 = 24;
    public static final int KeySize256 = 32;
    public static final int KeySize384 = 48;
    public static final int KeySize512 = 64;
    public static final int DefaultKeySize = 32;
    private final String kid;
    private final byte[] key;
    private final Provider provider;

    public SymmetricKey() {
        this(UUID.randomUUID().toString());
    }

    public SymmetricKey(String kid) {
        this(kid, 32);
    }

    public SymmetricKey(String kid, int keySizeInBytes) {
        this(kid, keySizeInBytes, null);
    }

    public SymmetricKey(String kid, int keySizeInBytes, Provider provider) {
        if (Strings.isNullOrWhiteSpace(kid)) {
            throw new IllegalArgumentException("kid");
        }
        if (keySizeInBytes != 16 && keySizeInBytes != 24 && keySizeInBytes != 32 && keySizeInBytes != 48 && keySizeInBytes != 64) {
            throw new IllegalArgumentException("The key material must be 128, 192, 256, 384 or 512 bits of data");
        }
        this.kid = kid;
        this.key = new byte[keySizeInBytes];
        this.provider = provider;
        Rng.nextBytes(this.key);
    }

    public SymmetricKey(String kid, byte[] keyBytes) {
        this(kid, keyBytes, null);
    }

    public SymmetricKey(String kid, byte[] keyBytes, Provider provider) {
        if (Strings.isNullOrWhiteSpace(kid)) {
            throw new IllegalArgumentException("kid");
        }
        if (keyBytes == null) {
            throw new IllegalArgumentException("keyBytes");
        }
        if (keyBytes.length != 16 && keyBytes.length != 24 && keyBytes.length != 32 && keyBytes.length != 48 && keyBytes.length != 64) {
            throw new IllegalArgumentException("The key material must be 128, 192, 256, 384 or 512 bits of data");
        }
        this.kid = kid;
        this.key = ByteExtensions.clone(keyBytes);
        this.provider = provider;
    }

    public String getDefaultEncryptionAlgorithm() {
        switch (this.key.length) {
            case 16: {
                return "A128CBC";
            }
            case 24: {
                return "A192CBC";
            }
            case 32: {
                return "A128CBC-HS256";
            }
            case 48: {
                return "A192CBC-HS384";
            }
            case 64: {
                return "A256CBC-HS512";
            }
        }
        return null;
    }

    public String getDefaultKeyWrapAlgorithm() {
        switch (this.key.length) {
            case 16: {
                return "A128KW";
            }
            case 24: {
                return "A192KW";
            }
            case 32: {
                return "A256KW";
            }
            case 48: {
                return "A256KW";
            }
            case 64: {
                return "A256KW";
            }
        }
        return null;
    }

    public String getDefaultSignatureAlgorithm() {
        return null;
    }

    public String getKid() {
        return this.kid;
    }

    public ListenableFuture<byte[]> decryptAsync(byte[] ciphertext, byte[] iv, byte[] authenticationData, byte[] authenticationTag, String algorithm) throws NoSuchAlgorithmException {
        if (Strings.isNullOrWhiteSpace(algorithm)) {
            throw new IllegalArgumentException("algorithm");
        }
        if (ciphertext == null) {
            throw new IllegalArgumentException("ciphertext");
        }
        if (iv == null) {
            throw new IllegalArgumentException("iv");
        }
        Algorithm baseAlgorithm = AlgorithmResolver.Default.get(algorithm);
        if (baseAlgorithm == null || !(baseAlgorithm instanceof SymmetricEncryptionAlgorithm)) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        SymmetricEncryptionAlgorithm algo = (SymmetricEncryptionAlgorithm)baseAlgorithm;
        ICryptoTransform transform = null;
        try {
            transform = algo.CreateDecryptor(this.key, iv, authenticationData, authenticationTag, this.provider);
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        byte[] result = null;
        try {
            result = transform.doFinal(ciphertext);
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        return Futures.immediateFuture((Object)result);
    }

    public ListenableFuture<Triple<byte[], byte[], String>> encryptAsync(byte[] plaintext, byte[] iv, byte[] authenticationData, String algorithm) throws NoSuchAlgorithmException {
        if (plaintext == null) {
            throw new IllegalArgumentException("plaintext");
        }
        if (iv == null) {
            throw new IllegalArgumentException("iv");
        }
        String algorithmName = Strings.isNullOrWhiteSpace(algorithm) ? this.getDefaultEncryptionAlgorithm() : algorithm;
        Algorithm baseAlgorithm = AlgorithmResolver.Default.get(algorithmName);
        if (baseAlgorithm == null || !(baseAlgorithm instanceof SymmetricEncryptionAlgorithm)) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        SymmetricEncryptionAlgorithm algo = (SymmetricEncryptionAlgorithm)baseAlgorithm;
        ICryptoTransform transform = null;
        try {
            transform = algo.CreateEncryptor(this.key, iv, authenticationData, this.provider);
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        byte[] cipherText = null;
        try {
            cipherText = transform.doFinal(plaintext);
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        byte[] authenticationTag = null;
        if (transform instanceof IAuthenticatedCryptoTransform) {
            IAuthenticatedCryptoTransform authenticatedTransform = (IAuthenticatedCryptoTransform)transform;
            authenticationTag = (byte[])authenticatedTransform.getTag().clone();
        }
        return Futures.immediateFuture((Object)Triple.of((Object)cipherText, authenticationTag, (Object)algorithm));
    }

    public ListenableFuture<Pair<byte[], String>> wrapKeyAsync(byte[] key, String algorithm) throws NoSuchAlgorithmException {
        if (key == null || key.length == 0) {
            throw new IllegalArgumentException("key");
        }
        String algorithmName = Strings.isNullOrWhiteSpace(algorithm) ? this.getDefaultKeyWrapAlgorithm() : algorithm;
        Algorithm baseAlgorithm = AlgorithmResolver.Default.get(algorithmName);
        if (baseAlgorithm == null || !(baseAlgorithm instanceof KeyWrapAlgorithm)) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
        KeyWrapAlgorithm algo = (KeyWrapAlgorithm)baseAlgorithm;
        ICryptoTransform transform = null;
        try {
            transform = algo.CreateEncryptor(this.key, null, this.provider);
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        byte[] encrypted = null;
        try {
            encrypted = transform.doFinal(key);
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        return Futures.immediateFuture((Object)Pair.of((Object)encrypted, (Object)algorithmName));
    }

    public ListenableFuture<byte[]> unwrapKeyAsync(byte[] encryptedKey, String algorithm) throws NoSuchAlgorithmException {
        if (Strings.isNullOrWhiteSpace(algorithm)) {
            throw new IllegalArgumentException("algorithm");
        }
        if (encryptedKey == null || encryptedKey.length == 0) {
            throw new IllegalArgumentException("wrappedKey");
        }
        Algorithm baseAlgorithm = AlgorithmResolver.Default.get(algorithm);
        if (baseAlgorithm == null || !(baseAlgorithm instanceof KeyWrapAlgorithm)) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        KeyWrapAlgorithm algo = (KeyWrapAlgorithm)baseAlgorithm;
        ICryptoTransform transform = null;
        try {
            transform = algo.CreateDecryptor(this.key, null, this.provider);
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        byte[] decrypted = null;
        try {
            decrypted = transform.doFinal(encryptedKey);
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        return Futures.immediateFuture((Object)decrypted);
    }

    public ListenableFuture<Pair<byte[], String>> signAsync(byte[] digest, String algorithm) {
        return Futures.immediateFailedFuture((Throwable)new NotImplementedException("signAsync is not currently supported"));
    }

    public ListenableFuture<Boolean> verifyAsync(byte[] digest, byte[] signature, String algorithm) {
        return Futures.immediateFailedFuture((Throwable)new NotImplementedException("verifyAsync is not currently supported"));
    }

    public void close() throws IOException {
    }
}

