/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.groovy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.atlas.groovy.AbstractGroovyExpression;
import org.apache.atlas.groovy.GroovyExpression;
import org.apache.atlas.groovy.GroovyGenerationContext;

public class ListExpression
extends AbstractGroovyExpression {
    private List<GroovyExpression> values = new ArrayList<GroovyExpression>();

    public ListExpression(GroovyExpression ... values) {
        this.values = Arrays.asList(values);
    }

    public ListExpression(List<? extends GroovyExpression> values) {
        this.values.addAll(values);
    }

    public void addArgument(GroovyExpression expr) {
        this.values.add(expr);
    }

    @Override
    public void generateGroovy(GroovyGenerationContext context) {
        context.append("[");
        Iterator<GroovyExpression> it = this.values.iterator();
        while (it.hasNext()) {
            GroovyExpression expr = it.next();
            expr.generateGroovy(context);
            if (!it.hasNext()) continue;
            context.append(", ");
        }
        context.append("]");
    }

    @Override
    public List<GroovyExpression> getChildren() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    public GroovyExpression copy(List<GroovyExpression> newChildren) {
        return new ListExpression(newChildren);
    }
}

