/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.groovy;

import java.util.Collections;
import java.util.List;
import org.apache.atlas.groovy.AbstractFunctionExpression;
import org.apache.atlas.groovy.GroovyExpression;
import org.apache.atlas.groovy.GroovyGenerationContext;
import org.apache.atlas.groovy.LiteralExpression;
import org.apache.atlas.groovy.TraversalStepType;

public class RangeExpression
extends AbstractFunctionExpression {
    private TraversalStepType stepType;
    private int startIndex;
    private int endIndex;

    public RangeExpression(TraversalStepType stepType, GroovyExpression parent, int offset, int count) {
        super(parent);
        this.startIndex = offset;
        this.endIndex = count;
        this.stepType = stepType;
    }

    @Override
    public void generateGroovy(GroovyGenerationContext context) {
        this.getCaller().generateGroovy(context);
        context.append(" [");
        new LiteralExpression(this.startIndex).generateGroovy(context);
        context.append("..<");
        new LiteralExpression(this.endIndex).generateGroovy(context);
        context.append("]");
    }

    @Override
    public List<GroovyExpression> getChildren() {
        return Collections.singletonList(this.getCaller());
    }

    @Override
    public GroovyExpression copy(List<GroovyExpression> newChildren) {
        assert (newChildren.size() == 1);
        return new RangeExpression(this.stepType, newChildren.get(0), this.startIndex, this.endIndex);
    }

    @Override
    public TraversalStepType getType() {
        return this.stepType;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }
}

