/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.AWSKMSClientBuilder;
import com.amazonaws.services.kms.model.AliasListEntry;
import com.amazonaws.services.kms.model.DecryptRequest;
import com.amazonaws.services.kms.model.DecryptResult;
import com.amazonaws.services.kms.model.DescribeKeyRequest;
import com.amazonaws.services.kms.model.DescribeKeyResult;
import com.amazonaws.services.kms.model.EncryptRequest;
import com.amazonaws.services.kms.model.EncryptResult;
import com.amazonaws.services.kms.model.KeyMetadata;
import com.amazonaws.services.kms.model.ListAliasesRequest;
import com.amazonaws.services.kms.model.ListAliasesResult;
import java.nio.ByteBuffer;
import java.security.Key;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.RangerKMSMKI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAWSKMSProvider
implements RangerKMSMKI {
    private static final Logger logger = LoggerFactory.getLogger(RangerAWSKMSProvider.class);
    static final String AWSKMS_MASTER_KEY_ID = "ranger.kms.awskms.masterkey.id";
    static final String AWS_CLIENT_ACCESSKEY = "ranger.kms.aws.client.accesskey";
    static final String AWS_CLIENT_SECRETKEY = "ranger.kms.aws.client.secretkey";
    static final String AWS_CLIENT_REGION = "ranger.kms.aws.client.region";
    private String masterKeyId;
    private KeyMetadata masterKeyMetadata;
    private AWSKMS keyVaultClient;

    protected RangerAWSKMSProvider(Configuration conf, AWSKMS client) {
        this.masterKeyId = conf.get(AWSKMS_MASTER_KEY_ID);
        this.keyVaultClient = client;
    }

    public RangerAWSKMSProvider(Configuration conf) throws Exception {
        this(conf, RangerAWSKMSProvider.createKMSClient(conf));
    }

    public static AWSKMS createKMSClient(Configuration conf) throws Exception {
        String awskmsClientAccessKey = conf.get(AWS_CLIENT_ACCESSKEY);
        String awskmsClientSecretKey = conf.get(AWS_CLIENT_SECRETKEY);
        String awskmsClientRegion = conf.get(AWS_CLIENT_REGION);
        AWSKMSClientBuilder builder = AWSKMSClientBuilder.standard();
        if (StringUtils.isNotEmpty((CharSequence)awskmsClientAccessKey) && StringUtils.isNotEmpty((CharSequence)awskmsClientSecretKey)) {
            builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(awskmsClientAccessKey, awskmsClientSecretKey)));
        }
        if (StringUtils.isNotEmpty((CharSequence)awskmsClientRegion)) {
            builder.withRegion(awskmsClientRegion);
        }
        return (AWSKMS)builder.build();
    }

    @Override
    public boolean generateMasterKey(String password) throws Exception {
        if (this.keyVaultClient == null) {
            throw new Exception("Key Vault Client is null. Please check the aws related configuration.");
        }
        DescribeKeyRequest desckey_req = new DescribeKeyRequest();
        desckey_req.setKeyId(this.masterKeyId);
        DescribeKeyResult desckey_resp = this.keyVaultClient.describeKey(desckey_req);
        if (desckey_resp == null) {
            throw new Exception("Fetch KeyMetadata by describeKey failed");
        }
        ListAliasesRequest listAliasesRequest = new ListAliasesRequest();
        listAliasesRequest.setKeyId(desckey_resp.getKeyMetadata().getKeyId());
        ListAliasesResult listAliasesResult = this.keyVaultClient.listAliases(listAliasesRequest);
        boolean aliasMatched = false;
        if (listAliasesResult != null) {
            for (AliasListEntry e : listAliasesResult.getAliases()) {
                logger.info("keyalias: " + e);
                if (!e.getAliasName().equals(this.masterKeyId) || !e.getTargetKeyId().equals(desckey_resp.getKeyMetadata().getKeyId())) continue;
                aliasMatched = true;
                break;
            }
        }
        if (!aliasMatched && !desckey_resp.getKeyMetadata().getKeyId().equals(this.masterKeyId)) {
            throw new Exception("KeyMetadata do not match masterKeyId");
        }
        this.masterKeyMetadata = desckey_resp.getKeyMetadata();
        if (this.masterKeyMetadata == null) {
            throw new NoSuchMethodException("generateMasterKey is not implemented for AWS KMS");
        }
        logger.info("AWS Master key exist with KeyId: " + this.masterKeyId + " with Arn: " + this.masterKeyMetadata.getArn() + " with Description : " + this.masterKeyMetadata.getDescription());
        return true;
    }

    @Override
    public byte[] encryptZoneKey(Key zoneKey) throws Exception {
        EncryptRequest req = new EncryptRequest();
        req.setKeyId(this.masterKeyId);
        req.setPlaintext(ByteBuffer.wrap(zoneKey.getEncoded()));
        EncryptResult resp = this.keyVaultClient.encrypt(req);
        ByteBuffer buf = resp.getCiphertextBlob();
        byte[] arr = new byte[buf.remaining()];
        buf.get(arr);
        return arr;
    }

    @Override
    public byte[] decryptZoneKey(byte[] encryptedByte) throws Exception {
        DecryptRequest req = new DecryptRequest();
        req.setCiphertextBlob(ByteBuffer.wrap(encryptedByte));
        DecryptResult resp = this.keyVaultClient.decrypt(req);
        ByteBuffer buf = resp.getPlaintext();
        byte[] arr = new byte[buf.remaining()];
        buf.get(arr);
        return arr;
    }

    @Override
    public String getMasterKey(String masterKeySecretName) {
        return null;
    }
}

