/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.azure.keyvault.models.Attributes;
import com.microsoft.azure.keyvault.models.KeyAttributes;
import com.microsoft.azure.keyvault.models.KeyOperationResult;
import com.microsoft.azure.keyvault.models.custom.KeyBundle;
import com.microsoft.azure.keyvault.requests.CreateKeyRequest;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyEncryptionAlgorithm;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyType;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import java.security.Key;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.AzureKeyVaultClientAuthenticator;
import org.apache.hadoop.crypto.key.RangerKMSMKI;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAzureKeyVaultKeyGenerator
implements RangerKMSMKI {
    static final Logger logger = LoggerFactory.getLogger(RangerAzureKeyVaultKeyGenerator.class);
    static final String AZURE_KEYVAULT_URL = "ranger.kms.azurekeyvault.url";
    static final String AZURE_MASTER_KEY_ALIAS = "ranger.kms.azure.masterkey.name";
    static final String AZURE_MASTER_KEY_TYPE = "ranger.kms.azure.masterkey.type";
    static final String ZONE_KEY_ENCRYPTION_ALGO = "ranger.kms.azure.zonekey.encryption.algorithm";
    static final String AZURE_KEYVAULT_SSL_ENABLED = "ranger.kms.azure.keyvault.ssl.enabled";
    static final String AZURE_CLIENT_ID = "ranger.kms.azure.client.id";
    static final String AZURE_CLIENT_SECRET = "ranger.kms.azure.client.secret";
    static final String AZURE_KEYVAULT_CERTIFICATE_PATH = "ranger.kms.azure.keyvault.certificate.path";
    static final String AZURE_KEYVAULT_CERTIFICATE_PASSWORD = "ranger.kms.azure.keyvault.certificate.password";
    private String keyVaultURL;
    private String azureMasterKey;
    private String azureMasterKeyType;
    private String zoneKeyEncryptionAlgo;
    private KeyVaultClient keyVaultClient;
    private KeyBundle masterKeyBundle;

    public RangerAzureKeyVaultKeyGenerator(Configuration conf, KeyVaultClient kvClient) {
        this.keyVaultURL = conf.get(AZURE_KEYVAULT_URL);
        this.azureMasterKey = conf.get(AZURE_MASTER_KEY_ALIAS);
        this.azureMasterKeyType = conf.get(AZURE_MASTER_KEY_TYPE);
        this.zoneKeyEncryptionAlgo = conf.get(ZONE_KEY_ENCRYPTION_ALGO);
        this.keyVaultClient = kvClient;
    }

    public RangerAzureKeyVaultKeyGenerator(Configuration conf) throws Exception {
        this(conf, RangerAzureKeyVaultKeyGenerator.createKeyVaultClient(conf));
    }

    public static KeyVaultClient createKeyVaultClient(Configuration conf) throws Exception {
        KeyVaultClient kvClient;
        String azureClientId = conf.get(AZURE_CLIENT_ID);
        if (StringUtils.isEmpty((CharSequence)azureClientId)) {
            throw new Exception("Azure Key Vault is enabled and client id is not configured");
        }
        String azureClientSecret = conf.get(AZURE_CLIENT_SECRET);
        if (conf != null && StringUtils.isNotEmpty((CharSequence)conf.get(AZURE_KEYVAULT_SSL_ENABLED)) && conf.get(AZURE_KEYVAULT_SSL_ENABLED).equalsIgnoreCase("false")) {
            try {
                if (StringUtils.isEmpty((CharSequence)azureClientSecret)) {
                    throw new Exception("Azure Key Vault is enabled in non SSL mode and client password/secret is not configured");
                }
                AzureKeyVaultClientAuthenticator azureKVClientAuthenticator = new AzureKeyVaultClientAuthenticator(azureClientId, azureClientSecret);
                kvClient = new KeyVaultClient((ServiceClientCredentials)azureKVClientAuthenticator);
            }
            catch (Exception ex) {
                throw new Exception("Error while getting key vault client object with client id and client secret : " + ex);
            }
        }
        try {
            AzureKeyVaultClientAuthenticator azureKVClientAuthenticator = new AzureKeyVaultClientAuthenticator(azureClientId);
            String keyVaultCertPath = conf.get(AZURE_KEYVAULT_CERTIFICATE_PATH);
            if (StringUtils.isEmpty((CharSequence)keyVaultCertPath)) {
                throw new Exception("Azure Key Vault is enabled in SSL mode. Please provide certificate path for authentication.");
            }
            String keyVaultCertPassword = conf.get(AZURE_KEYVAULT_CERTIFICATE_PASSWORD);
            kvClient = !StringUtils.isEmpty((CharSequence)keyVaultCertPassword) ? azureKVClientAuthenticator.getAuthentication(keyVaultCertPath, keyVaultCertPassword) : azureKVClientAuthenticator.getAuthentication(keyVaultCertPath, "");
        }
        catch (Exception ex) {
            throw new Exception("Error while getting key vault client object with client id and certificate. Error :  : " + ex);
        }
        return kvClient;
    }

    @Override
    public boolean generateMasterKey(String password) throws Exception {
        if (this.keyVaultClient == null) {
            throw new Exception("Key Vault Client is null. Please check the azure related configuration.");
        }
        try {
            this.masterKeyBundle = this.keyVaultClient.getKey(this.keyVaultURL, this.azureMasterKey);
        }
        catch (Exception ex) {
            throw new Exception("Error while getting existing master key from Azure.  Master Key Name : " + this.azureMasterKey + " . Key Vault URL : " + this.keyVaultURL + " . Error : " + ex.getMessage());
        }
        if (this.masterKeyBundle == null) {
            try {
                JsonWebKeyType keyType;
                switch (this.azureMasterKeyType) {
                    case "RSA": {
                        keyType = JsonWebKeyType.RSA;
                        break;
                    }
                    case "RSA_HSM": {
                        keyType = JsonWebKeyType.RSA_HSM;
                        break;
                    }
                    case "EC": {
                        keyType = JsonWebKeyType.EC;
                        break;
                    }
                    case "EC_HSM": {
                        keyType = JsonWebKeyType.EC_HSM;
                        break;
                    }
                    case "OCT": {
                        keyType = JsonWebKeyType.OCT;
                        break;
                    }
                    default: {
                        keyType = JsonWebKeyType.RSA;
                    }
                }
                Attributes masterKeyattribute = new KeyAttributes().withEnabled(Boolean.valueOf(true)).withNotBefore(new DateTime());
                CreateKeyRequest createKeyRequest = new CreateKeyRequest.Builder(this.keyVaultURL, this.azureMasterKey, keyType).withAttributes(masterKeyattribute).build();
                this.masterKeyBundle = (KeyBundle)this.keyVaultClient.createKeyAsync(createKeyRequest, null).get();
                return true;
            }
            catch (Exception ex) {
                throw new Exception("Error while creating master key  : " + ex.getMessage());
            }
        }
        logger.info("Azure Master key exist with name :" + this.azureMasterKey + " with key identifier " + this.masterKeyBundle.key().kid());
        return true;
    }

    @Override
    public byte[] encryptZoneKey(Key zoneKey) throws Exception {
        JsonWebKeyEncryptionAlgorithm keyEncryptionAlgo = this.getZoneKeyEncryptionAlgo();
        KeyOperationResult encryptResult = null;
        if (this.masterKeyBundle == null) {
            this.masterKeyBundle = this.keyVaultClient.getKey(this.keyVaultURL, this.azureMasterKey);
        }
        try {
            encryptResult = (KeyOperationResult)this.keyVaultClient.encryptAsync(this.masterKeyBundle.key().kid(), keyEncryptionAlgo, zoneKey.getEncoded(), null).get();
        }
        catch (Exception e) {
            throw new Exception("Error while encrypting zone key." + e);
        }
        return encryptResult.result();
    }

    @Override
    public byte[] decryptZoneKey(byte[] encryptedByte) throws Exception {
        JsonWebKeyEncryptionAlgorithm keyEncryptionAlgo = this.getZoneKeyEncryptionAlgo();
        if (this.masterKeyBundle == null) {
            this.masterKeyBundle = this.keyVaultClient.getKey(this.keyVaultURL, this.azureMasterKey);
        }
        KeyOperationResult decryptResult = null;
        try {
            decryptResult = (KeyOperationResult)this.keyVaultClient.decryptAsync(this.masterKeyBundle.key().kid(), keyEncryptionAlgo, encryptedByte, null).get();
        }
        catch (Exception e) {
            throw new Exception("Error while decrypting zone key." + e);
        }
        return decryptResult.result();
    }

    private JsonWebKeyEncryptionAlgorithm getZoneKeyEncryptionAlgo() {
        JsonWebKeyEncryptionAlgorithm keyEncryptionAlgo;
        switch (this.zoneKeyEncryptionAlgo) {
            case "RSA_OAEP": {
                keyEncryptionAlgo = JsonWebKeyEncryptionAlgorithm.RSA_OAEP;
                break;
            }
            case "RSA_OAEP_256": {
                keyEncryptionAlgo = JsonWebKeyEncryptionAlgorithm.RSA_OAEP_256;
                break;
            }
            case "RSA1_5": {
                keyEncryptionAlgo = JsonWebKeyEncryptionAlgorithm.RSA1_5;
                break;
            }
            default: {
                keyEncryptionAlgo = JsonWebKeyEncryptionAlgorithm.RSA_OAEP;
            }
        }
        return keyEncryptionAlgo;
    }

    @Override
    public String getMasterKey(String masterKeySecretName) {
        return null;
    }
}

